<?php
/*
 * @copyright Copyright (c) 2022 AltumCode (https://altumcode.com/)
 *
 * This software is exclusively sold through https://altumcode.com/ by the AltumCode author.
 * Downloading this product from any other sources and running it without a proper license is illegal,
 *  except the official ones linked from https://altumcode.com/.
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose Language',
    'global.theme_style' => 'Switch to %s Mode',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available..',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.export' => 'Export',
    'global.export_csv' => 'Export to CSV',
    'global.export_json' => 'Export to JSON',
    'global.export_pdf' => 'Export to PDF',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',

    'global.info_message.confirm_delete' => 'Are you sure you want to delete this?',
    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is limited. Please get a new plan!',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the fields!',
    'global.error_message.empty_field' => 'This field is required, you must fill it!',
    'global.error_message.invalid_captcha' => 'The captcha code is not valid!',
    'global.error_message.invalid_file_type' => 'Invalid file type!',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again!',
    'global.error_message.basic' => 'We could not perform your requested command!',
    'global.error_message.file_size_limit' => 'Your uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'Your password must be between 6 and 64 characters!',
    'global.error_message.passwords_not_matching' => 'Your entered passwords do not match!',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website Logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha Field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.status' => 'Status',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.all' => 'All',
    'global.filters.results_per_page' => 'Results per page',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s until',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and you are ready,<br /><br />you just need to click the following link in order to join {{WEBSITE_TITLE}}<br /><br /><a href="{{ACTIVATION_LINK}}">Activate your account</a><br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}">Confirm email address change</a><br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is your reset password link: <a href="{{LOST_PASSWORD_LINK}}">Reset Password</a><br /><br />If you did not request this, you can ignore it!<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />Your account plan is now paid until {{PLAN_EXPIRATION_DATE}}!<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_data_collected.subject' => 'New data for {{BLOCK_TITLE}} - {{WEBSITE_TITLE}}',
    'global.emails.user_data_collected_phone_collector.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You just got a new data submission from one of your visitors.<br /><br /><strong>Phone:</strong> {{DATA_PHONE}}<br /><strong>Name:</strong> {{DATA_NAME}}<br /><br /><a href="{{DATA_LINK}}">View all data</a><br /><br />Greetings from {{WEBSITE_TITLE}}!',
    'global.emails.user_data_collected_mail.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You just got a new data submission from one of your visitors.<br /><br /><strong>Email:</strong> {{DATA_EMAIL}}<br /><strong>Name:</strong> {{DATA_NAME}}<br /><br /><a href="{{DATA_LINK}}">View all data</a><br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_guest_payment_donation.subject' => '{{TOTAL_AMOUNT}} {{CURRENCY}} donation for {{DONATION_TITLE}} - {{WEBSITE_TITLE}}',
    'global.emails.user_guest_payment_donation.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You just got a new donation from one of your visitors.<br /><br /><strong>Email:</strong> {{EMAIL}}<br /><strong>Name:</strong> {{NAME}}<br /><strong>Total amount:</strong> {{TOTAL_AMOUNT}}<br /><strong>Currency:</strong> {{CURRENCY}}<br /><strong>Processor:</strong> {{PROCESSOR}}<br /><strong>Donation:</strong> {{DONATION_TITLE}}<br /><strong>Message:</strong> {{MESSAGE}}<br /><br /><a href="{{GUESTS_PAYMENTS_LINK}}">View all payments</a><br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_guest_payment_product.subject' => '{{PRODUCT_TITLE}} sold for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.user_guest_payment_product.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You just got a new payment from one of your visitors, for one of your products.<br /><br /><strong>Email:</strong> {{EMAIL}}<br /><strong>Name:</strong> {{NAME}}<br /><strong>Total amount:</strong> {{TOTAL_AMOUNT}}<br /><strong>Currency:</strong> {{CURRENCY}}<br /><strong>Processor:</strong> {{PROCESSOR}}<br /><strong>Product:</strong> {{PRODUCT_TITLE}}<br /><br /><a href="{{GUESTS_PAYMENTS_LINK}}">View all payments</a><br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.guest_guest_payment_product.subject' => 'You purchased {{PRODUCT_TITLE}} - {{WEBSITE_TITLE}}',
    'global.emails.guest_guest_payment_product.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is the official email notice that your payment is successful. You can use the download link below to download the product you purchased.<br /><br /><strong>Download link:</strong> {{DOWNLOAD_LINK}}<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_guest_payment_service.subject' => '{{SERVICE_TITLE}} sold for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.user_guest_payment_service.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You just got a new payment from one of your visitors, for one of your services.<br /><br /><strong>Email:</strong> {{EMAIL}}<br /><strong>Name:</strong> {{NAME}}<br /><strong>Total amount:</strong> {{TOTAL_AMOUNT}}<br /><strong>Currency:</strong> {{CURRENCY}}<br /><strong>Processor:</strong> {{PROCESSOR}}<br /><strong>Service:</strong> {{SERVICE_TITLE}}<br /><strong>Message:</strong> {{MESSAGE}}<br /><br /><a href="{{GUESTS_PAYMENTS_LINK}}">View all payments</a><br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.guest_guest_payment_service.subject' => 'You paid for {{SERVICE_TITLE}} - {{WEBSITE_TITLE}}',
    'global.emails.guest_guest_payment_service.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is the official email notice that your payment is successful. You will get contacted by the provider of the service as soon as possible.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your {{PLAN_NAME}} plan is going to expire in {{DAYS_UNTIL_EXPIRATION}} days.<br /><br />Please <a href="{{USER_PLAN_RENEW_LINK}}">renew your plan</a> if you wish to continue using our website with all the features you have.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply <a href="{{LOGIN_LINK}}">login</a> with your account and the deletion process will be stopped.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to <a href="{{REGISTER_LINK}}">register</a> another account with us.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM_NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hey there,<br /><br />You have been invited by <strong>{{USER_NAME}}</strong> ({{USER_EMAIL}}) to join the <strong>{{TEAM_NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}">login and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}!',
    'global.emails.team_member_create.body_register' => 'Hey there,<br /><br />You have been invited by <strong>{{USER_NAME}}</strong> ({{USER_EMAIL}}) to join the <strong>{{TEAM_NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}">register and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => 'Hey!<br /><br />A new user just registered to the website!<br /><br />Welcome to <strong>{{NAME}}</strong> ({{EMAIL}}) to your website!',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => 'Hey!<br /><br /><strong>{{NAME}}</strong> ({{EMAIL}}) user just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> to your website!<br /><br />Here\'s to more earnings!',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => 'Hey!<br /><br /><strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => 'Hey!<br /><br /><strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => 'Hey,<br /><br /><strong>{{NAME}}</strong> - {{EMAIL}} has sent you the following message:<br /><br />{{MESSAGE}}',

    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent. <button type="button" data-cc="c-settings" class="cc-link">Let me choose</button>',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.save' => 'Save settings',
    'global.cookie_consent.close' => 'Close',

    'global.footer.copyright' => 'Copyright © %1$s %2$s.',

    'global.plan_settings.additional_global_domains' => '<i class="fa fa-fw fa-sm fa-globe mr-1"></i> Additional Global Domains',
    'global.plan_settings.additional_global_domains_help' => 'You get access to extra domains to use.',
    'global.plan_settings.custom_url' => '<i class="fa fa-fw fa-sm fa-link mr-1"></i> Custom Back-half',
    'global.plan_settings.custom_url_help' => 'Instead of auto generated urls, like /a853we6, you get to choose your own',
    'global.plan_settings.deep_links' => '<i class="fa fa-fw fa-sm fa-paperclip mr-1"></i> Deep linking',
    'global.plan_settings.deep_links_help' => 'Provides the ability to enter deep links, like: steam://rungameid/id',
    'global.plan_settings.no_ads' => '<i class="fa fa-fw fa-sm fa-eye-slash mr-1"></i> No Ads',
    'global.plan_settings.no_ads_help' => 'You won\'t see any ads on the platform and neither will ads be placed on your biolink pages',
    'global.plan_settings.removable_branding' => '<i class="fa fa-fw fa-sm fa-eye-slash mr-1"></i> Removable branding',
    'global.plan_settings.removable_branding_help' => 'All the branding will be removed from your created Biolinks',
    'global.plan_settings.custom_branding' => '<i class="fa fa-fw fa-sm fa-ad mr-1"></i> Custom branding',
    'global.plan_settings.custom_branding_help' => 'Change and whitelabel the branding of your Biolinks',
    'global.plan_settings.custom_colored_links' => '<i class="fa fa-fw fa-sm fa-paint-brush mr-1"></i> Custom colors',
    'global.plan_settings.custom_colored_links_help' => 'You can choose your own custom colors for links inside of the biolink pages',
    'global.plan_settings.statistics' => '<i class="fa fa-fw fa-sm fa-chart-bar mr-1"></i> Indepth Statistics',
    'global.plan_settings.statistics_help' => 'You get access to more advanced statistics for all your links',
    'global.plan_settings.custom_backgrounds' => '<i class="fa fa-fw fa-sm fa-fill mr-1"></i> Custom Backgrounds',
    'global.plan_settings.custom_backgrounds_help' => 'You can add your own custom Biolink page backgrounds',
    'global.plan_settings.temporary_url_is_enabled' => '<i class="fa fa-fw fa-sm fa-clock mr-1"></i> Links scheduling & limiter',
    'global.plan_settings.temporary_url_is_enabled_help' => 'The ability to schedule links for when to go live & when to expire based on amount of clicks or date range.',
    'global.plan_settings.seo' => '<i class="fa fa-fw fa-sm fa-search-plus mr-1"></i> SEO Features',
    'global.plan_settings.seo_help' => 'Customize the meta tags for your biolink pages',
    'global.plan_settings.utm' => '<i class="fa fa-fw fa-sm fa-key mr-1"></i> UTM Parameters',
    'global.plan_settings.utm_help' => 'Easily adjust the UTM parameters for all your links',
    'global.plan_settings.fonts' => '<i class="fa fa-fw fa-sm fa-pen-nib mr-1"></i> Extra Fonts',
    'global.plan_settings.fonts_help' => 'Get access to multiple fonts to use for your biolink page',
    'global.plan_settings.password' => '<i class="fa fa-fw fa-sm fa-lock mr-1"></i> Password protection',
    'global.plan_settings.password_help' => 'Get access to password protect your links or biolink pages',
    'global.plan_settings.sensitive_content' => '<i class="fa fa-fw fa-sm fa-eye mr-1"></i> Sensitive content',
    'global.plan_settings.sensitive_content_help' => 'Get access to enable sensitive content warning on your links or biolink pages',
    'global.plan_settings.leap_link' => '<i class="fa fa-fw fa-sm fa-forward mr-1"></i> Leap link',
    'global.plan_settings.leap_link_help' => 'The ability to temporarily redirect a biolink page to a specific URL (useful when having promotions)',
    'global.plan_settings.dofollow_is_enabled' => '<i class="fa fa-fw fa-sm fa-link mr-1"></i> Dofollow links',
    'global.plan_settings.dofollow_is_enabled_help' => 'All your links from your biolink pages will be dofollow links.',
    'global.plan_settings.biolink_blocks_limit' => '<strong>%s</strong> Biolink Blocks',
    'global.plan_settings.projects_limit' => '<strong>%s</strong> Projects',
    'global.plan_settings.pixels_limit' => '<strong>%s</strong> Pixels',
    'global.plan_settings.qr_codes_limit' => '<strong>%s</strong> QR Codes',
    'global.plan_settings.biolinks_limit' => '<strong>%s</strong> Biolink Pages',
    'global.plan_settings.links_limit' => '<strong>%s</strong> Shortened Links',
    'global.plan_settings.domains_limit' => '<strong>%s</strong> Custom Domains',
    'global.plan_settings.payment_processors_limit' => '<strong>%s</strong> Payment Processors',
    'global.plan_settings.track_links_retention' => '%s days statistics retention',
    'global.plan_settings.enabled_biolink_blocks_all' => 'All Biolink Blocks',
    'global.plan_settings.enabled_biolink_blocks_x' => '%s Enabled Biolink Blocks',
    'global.plan_settings.api_is_enabled' => '<i class="fa fa-fw fa-code mr-1"></i> API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.custom_css_is_enabled' => '<i class="fa fa-fw fa-code mr-1"></i> Custom CSS',
    'global.plan_settings.custom_css_is_enabled_help' => 'Add your own CSS to your vcards for more customizability.',
    'global.plan_settings.custom_js_is_enabled' => '<i class="fa fa-fw fa-code mr-1"></i> Custom JS',
    'global.plan_settings.custom_js_is_enabled_help' => 'Add your own JavaScript code to your vcards, like a custom tracking code, help chat..etc',
    'global.plan_settings.affiliate_is_enabled' => '<i class="fa fa-fw fa-comments-dollar mr-1"></i> Affiliate access',
    'global.plan_settings.affiliate_is_enabled_help' => 'Get access to the affiliate program to earn money.',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.last_datetime' => 'Last updated on: %s',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.total_views' => '(%s views)',

    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',

    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',

    'pages.pages_category.breadcrumb' => 'Pages Category',

    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select the most convenient plan for you.',
    'plan.header_renew' => 'Renew your plan',
    'plan.subheader_renew' => 'Select one plan to renew your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one plan to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plan.button.choose' => 'Choose plan',
    'plan.button.renew' => 'Renew plan',
    'plan.button.trial' => 'Try for %s days',
    'plan.button.contact' => 'Contact us',

    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',

    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'Your already have the free plan activated!',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires!',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly Payments',
    'pay.custom_plan.annual' => 'Annual Payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'I have a discount/redeemable code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One Time Payment',
    'pay.custom_plan.recurring_type' => 'Recurring Payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid..',
    'pay.error_message.code_used' => 'You have already used this code..',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',

    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s Plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade Plan',
    'account.plan.renew_plan' => 'Renew/Change Plan',
    'account.plan.renew' => 'Renew/Upgrade',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Basic profile settings of your account.',
    'account.settings.email' => 'Email',
    'account.settings.name' => 'Name',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',

    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.city' => 'City',
    'account.billing.county' => 'County',
    'account.billing.country' => 'Country',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',

    'account.change_password.header' => 'Change Password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current Password',
    'account.change_password.new_password' => 'New Password',
    'account.change_password.repeat_password' => 'Repeat Password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open the authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the following QR Code with your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Try inserting the following secret code into your app if you can\'t scan the QR Code.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, please enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',

    'account.error_message.invalid_current_password' => 'Your current password is not valid!',
    'account.error_message.twofa_check' => 'The token that you entered is not valid, please try again to setup the Two-factor authentication system.',

    'account.success_message.account_updated' => 'Your account was updated!',
    'account.success_message.password_updated' => 'Your account password was updated!',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. <br /> This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',

    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid!',
    'account_delete.success_message' => 'Your account was fully deleted! We\'re sorry to see you go!',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'domains.breadcrumb' => 'Custom domains',
    'domains.title' => 'Custom domains',
    'domains.menu' => 'Custom domains',
    'domains.header' => 'Custom domains',
    'domains.subheader' => 'Here you can add your own custom domain to use with your biolink pages.',

    'domains.table.host' => 'Domain',
    'domains.table.is_enabled_pending' => 'Pending',
    'domains.table.is_enabled_active' => 'Active',

    'domains.input.host' => 'Domain or subdomain',
    'domains.input.host_placeholder' => 'domain.com',
    'domains.input.host_help' => 'Write the domain or subdomain you want your links to be accessible with.',
    'domains.input.custom_index_url' => 'Custom index URL',
    'domains.input.custom_index_url_help' => 'Redirect to a specific URL when visitors land on the index of the domain.',
    'domains.input.custom_index_url_placeholder' => 'https://domain.com/',
    'domains.input.custom_not_found_url' => 'Custom 404 not found URL',
    'domains.input.custom_not_found_url_help' => 'Redirect to a specific URL when visitors land on a not found page of the domain.',
    'domains.input.custom_not_found_url_placeholder' => 'https://domain.com/404-page',
    'domains.no_data' => 'No custom domains..',
    'domains.no_data_help' => 'Add one now',


    'domain_create_modal.header' => 'Add custom domain',
    'domain_create_modal.subheader' => 'Make sure that your domain or subdomain has an A record pointing to %1$s or CNAME record pointing to %2$s.',
    'domain_create_modal.success_message' => 'Your custom domain has been submitted for approval and processing!',


    'domain_update_modal.header' => 'Edit domain',
    'domain_update_modal.subheader' => 'Edit your domain\'s details.',
    'domain_update_modal.success_message' => 'Your custom domain update has been submitted for approval and processing!',


    'domain_delete_modal.header' => 'Delete domain',
    'domain_delete_modal.subheader' => 'All data related to the domain will be completely deleted. This action cannot be undone.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',
    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',
    'account_plan.cancel.header' => 'Cancel Subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel Subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',
    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled!',


    'account_payments.title' => 'Account Payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account Payments',
    'account_payments.subheader' => 'All the payments made on your account.',


    'account_payments.payments.customer' => 'Customer',
    'account_payments.payments.type' => 'Type',
    'account_payments.payments.date' => 'Date',
    'account_payments.payments.name' => 'Full Name',
    'account_payments.payments.total_amount' => 'Total Amount',
    'account_payments.payments.plan_id' => 'Plan',
    'account_payments.payments.invoice' => 'Invoice',
    'account_payments.payments.status_pending' => 'Pending approval',
    'account_payments.payments.status_approved' => 'Approved',
    'account_payments.payments.no_data' => 'No payments for now..',


    'account_payments.filters.processor' => 'Processor',
    'account_payments.filters.type' => 'Type',
    'account_payments.filters.type_one_time' => 'One time',
    'account_payments.filters.type_recurring' => 'Recurring',
    'account_payments.filters.frequency' => 'Frequency',
    'account_payments.filters.frequency_monthly' => 'Monthly',
    'account_payments.filters.frequency_annual' => 'Annual',
    'account_payments.filters.frequency_lifetime' => 'Lifetime',
    'account_payments.filters.order_by_total_amount' => 'Total amount',


    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',


    'account_logs.logs.type' => 'Type',
    'account_logs.logs.ip' => 'IP',
    'account_logs.logs.datetime' => 'Date',
    'account_logs.logs.details' => 'Details',
    'account_logs.logs.no_data' => 'Your account has no recorded logs..',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Your API key. If needed, you can get a new one by hitting the button below. Looking for the %sAPI Documentation?%s',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully!',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams system',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.input.name' => 'Name',
    'teams.table.members' => 'Members',
    'teams.table.datetime' => 'Created on',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_delete_modal.header' => 'Delete team',
    'team_delete_modal.subheader' => 'By deleting the team, all the data associated with the team will be lost. This action cannot be undone.',


    'team_members.create' => 'Invite member',
    'team_members.input.user_email' => 'Email',
    'team_members.input.access' => 'Access',
    'team_members.input.access_help' => 'Set what permissions you want to hand out to the user.',
    'team_members.input.access.read' => 'View',
    'team_members.input.access.create' => 'Create',
    'team_members.input.access.update' => 'Update',
    'team_members.input.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status' => 'Status',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited on',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.invalid_email' => 'This email is invalid.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'team_member_delete_modal.header' => 'Delete team member',
    'team_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member.title' => 'Teams member',
    'teams_member.menu' => 'Teams member',
    'teams_member.breadcrumb' => 'Teams member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited on',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.button' => 'Copy referral link',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid' => 'Is paid',
    'referrals.withdraw.is_paid_paid' => 'Paid!',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing!',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'INVOICE',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.city' => 'City',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.country' => 'Country',
    'invoice.email' => 'Email',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.table.item' => 'Item',
    'invoice.table.amount' => 'Amount',
    'invoice.table.plan' => '%s Plan',
    'invoice.table.frequency' => '%s access.',
    'invoice.table.frequency_monthly' => '30 days',
    'invoice.table.frequency_annual' => '1 year',
    'invoice.table.frequency_lifetime' => 'Lifetime',
    'invoice.table.code' => 'Discount',
    'invoice.table.code_help' => 'Code used: %s',
    'invoice.table.total' => 'Total',
    'invoice.table.paid_via' => 'Paid via %s',


    'login.menu' => 'Login',
    'login.title' => 'Login',
    'login.header' => 'Login',

    'login.form.email' => 'Email Address',
    'login.form.email_placeholder' => 'email@domain.com',
    'login.form.password' => 'Password',
    'login.form.password_placeholder' => 'Password',
    'login.form.twofa_token' => 'Two-factor token',
    'login.form.twofa_token_placeholder' => 'Token code from the authenticator app',
    'login.form.remember_me' => 'Remember me',
    'login.form.login' => 'Login',

    'login.display.register' => 'Don\'t have an account? %s',
    'login.display.register_help' => 'Register',
    'login.display.lost_password' => 'Lost Password',
    'login.display.resend_activation' => 'Resend Activation',
    'login.display.facebook' => 'Facebook Login',
    'login.display.google' => 'Google Login',
    'login.display.twitter' => 'Twitter Login',
    'login.display.discord' => 'Discord Login',

    'login.info_message.twofa_token' => 'Use your authenticator app to get the token for the Two-factor authentication.',
    'login.info_message.logged_in' => 'Welcome back, %s! You\'ve successfully logged in.',

    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid!',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid!',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned!',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.email' => 'Email',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We sent an email to you if there is an account registered with it!',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.email' => 'Email',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We sent an email to you if there is an account registered with it!',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password was set!',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active!',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed!',


    'register.title' => 'Register',
    'register.menu' => 'Register',
    'register.header' => 'Register',
    'register.login' => 'Already have an account?',

    'register.form.name' => 'Name',
    'register.form.name_placeholder' => 'Your full name',
    'register.form.email' => 'Email',
    'register.form.email_placeholder' => 'email@domain.com',
    'register.form.password' => 'Password',
    'register.form.password_placeholder' => 'Password',
    'register.form.repeat_password' => 'Repeat Password',
    'register.form.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.form.register' => 'Register',

    'register.error_message.name_length' => 'Name must be between 1 and 64 characters!',
    'register.error_message.email_exists' => 'This email address is already in use!',
    'register.error_message.invalid_email' => 'This email address is invalid!',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted!',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted!',

    'register.success_message.registration' => 'Check your email for the activation link of your account!',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here!',


    'dashboard.title' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.links_clicks' => 'Links pageviews',
    'dashboard.biolinks_clicks' => 'Biolinks pageviews',
    'dashboard.links' => 'Total links',
    'dashboard.biolinks' => 'Total biolinks',
    'dashboard.projects' => 'Total projects',
    'dashboard.domains' => 'Total domains',


    'index.breadcrumb' => 'Home',
    'index.title' => 'Multiple Bio Links for Instagram',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => 'Do everything with just one link.',
    'index.subheader' => 'Shorten URLs, create bio link pages & custom QR codes. All with proper analytics of your visitors.',
    'index.sign_up' => 'Get Started',
    'index.example' => 'Bio page Demo',

    'index.presentation1.header' => 'Bio link pages',
    'index.presentation1.subheader' => 'Create your own unique & highly customizable bio link page with ease.',
    'index.presentation1.feature1' => 'Custom colors & branding',
    'index.presentation1.feature2' => 'Multiple ready-to-use components',
    'index.presentation1.feature3' => 'SEO settings',
    'index.presentation1.feature4' => 'Password protection, sensitive content warning',

    'index.presentation2.header' => 'Shortened links',
    'index.presentation2.subheader' => 'Yes! You can use our service as a shortener as well.',
    'index.presentation2.feature1' => 'Scheduling & expiration limits',
    'index.presentation2.feature2' => 'Country, device & language targeting',
    'index.presentation2.feature3' => 'A/B Rotation',
    'index.presentation2.feature4' => 'Password protection, sensitive content warning',

    'index.presentation3.header' => 'QR Codes',
    'index.presentation3.subheader' => 'Fully featured QR code generator system with easy to use templates.',
    'index.presentation3.feature1' => 'Custom colors with gradients',
    'index.presentation3.feature2' => 'Custom logo',
    'index.presentation3.feature3' => 'Vcard, WiFi, Calendar, Location..etc templates',

    'index.presentation4.header' => 'Built-in analytics',
    'index.presentation4.subheader' => 'Day by day analytics, referrers, countries, operating systems, languages and many more.',

    'index.stats.links' => 'Links',
    'index.stats.qr_codes' => 'QR Codes',
    'index.stats.track_links' => 'Tracked pageviews',

    'index.pixels.header' => 'Tracking pixels',
    'index.pixels.subheader' => '%s tracking pixels available.',

    'index.domains.header' => 'Custom domains',
    'index.domains.subheader' => 'Connect your own domain or use our predefined ones.',

    'index.projects.header' => 'Projects',
    'index.projects.subheader' => 'Easiest way to categorize your managed resources.',

    'index.pricing.header' => 'Pricing plans',
    'index.pricing.subheader' => 'Choose and get exactly what you need.',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',

    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'Get API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.details' => 'Details',
    'api_documentation.description' => 'Description',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.user.breadcrumb' => 'User',
    'api_documentation.user.title' => 'User API Documentation',
    'api_documentation.user.header' => 'User',
    'api_documentation.user.read_header' => 'Retrieve user',

    'api_documentation.links.breadcrumb' => 'Links',
    'api_documentation.links.title' => 'Links API Documentation',
    'api_documentation.links.header' => 'Links',
    'api_documentation.links.read_all_header' => 'Retrieve links',
    'api_documentation.links.read_header' => 'Retrieve a link',

    'api_documentation.statistics.breadcrumb' => 'Links statistics',
    'api_documentation.statistics.title' => 'Links statistics API Documentation',
    'api_documentation.statistics.header' => 'Links statistics',
    'api_documentation.statistics.read_header' => 'Retrieve links statistics',
    'api_documentation.statistics.start_date' => 'Start date in <code>Y-m-d</code> format.',
    'api_documentation.statistics.end_date' => 'End date in <code>Y-m-d</code> format.',
    'api_documentation.statistics.type' => 'Type of data to be returned. Allowed values are: <code>overview</code>, <code>referrer_host</code>, <code>referrer_path</code>, <code>country_code</code>, <code>city_name</code>, <code>os_name</code>, <code>browser_name</code>, <code>device_type</code>, <code>browser_language</code>, <code>utm_source</code>, <code>utm_medium</code>, <code>utm_campaign</code>. Defaults to <code>overview</code>.',
    'api_documentation.statistics.country_code' => 'Parameter only available for the <code>city_name</code> type.',
    'api_documentation.statistics.utm_source' => 'Parameter only available for the <code>utm_medium</code> and <code>utm_campaign</code> type.',
    'api_documentation.statistics.utm_medium' => 'Parameter only available for the <code>utm_campaign</code> type.',

    'api_documentation.projects.breadcrumb' => 'Projects',
    'api_documentation.projects.title' => 'Projects API Documentation',
    'api_documentation.projects.header' => 'Projects',
    'api_documentation.projects.read_all_header' => 'Retrieve projects',
    'api_documentation.projects.read_header' => 'Retrieve a project',
    'api_documentation.projects.create_header' => 'Add a new project',
    'api_documentation.projects.update_header' => 'Edit a project',
    'api_documentation.projects.delete_header' => 'Delete a project',

    'api_documentation.pixels.breadcrumb' => 'Pixels',
    'api_documentation.pixels.title' => 'Pixels API Documentation',
    'api_documentation.pixels.header' => 'Pixels',
    'api_documentation.pixels.read_all_header' => 'Retrieve pixels',
    'api_documentation.pixels.read_header' => 'Retrieve a pixel',
    'api_documentation.pixels.create_header' => 'Add a new pixel',
    'api_documentation.pixels.update_header' => 'Edit a pixel',
    'api_documentation.pixels.delete_header' => 'Delete a pixel',
    'api_documentation.pixels.type' => 'Allowed values are: %s.',

    'api_documentation.qr_codes.breadcrumb' => 'QR codes',
    'api_documentation.qr_codes.title' => 'QR codes API Documentation',
    'api_documentation.qr_codes.header' => 'QR codes',
    'api_documentation.qr_codes.read_all_header' => 'Retrieve QR codes',
    'api_documentation.qr_codes.read_header' => 'Retrieve a QR code',
    'api_documentation.qr_codes.create_header' => 'Add a new QR code',
    'api_documentation.qr_codes.update_header' => 'Edit a QR code',
    'api_documentation.qr_codes.delete_header' => 'Delete a QR code',

    'api_documentation.data.breadcrumb' => 'Data',
    'api_documentation.data.title' => 'Data API Documentation',
    'api_documentation.data.header' => 'Data',
    'api_documentation.data.read_all_header' => 'Retrieve data',
    'api_documentation.data.read_header' => 'Retrieve datum',
    'api_documentation.data.delete_header' => 'Delete datum',

    'api_documentation.domains.breadcrumb' => 'Custom domains',
    'api_documentation.domains.title' => 'Custom domains API Documentation',
    'api_documentation.domains.header' => 'Custom domains',
    'api_documentation.domains.read_all_header' => 'Retrieve custom domains',
    'api_documentation.domains.read_header' => 'Retrieve a custom domain',
    'api_documentation.domains.create_header' => 'Add a new custom domain',
    'api_documentation.domains.update_header' => 'Edit a custom domain',
    'api_documentation.domains.delete_header' => 'Delete a custom domain',

    'api_documentation.payments.breadcrumb' => 'Payments',
    'api_documentation.payments.title' => 'Payments API Documentation',
    'api_documentation.payments.header' => 'Payments',
    'api_documentation.payments.read_all_header' => 'Retrieve payments',
    'api_documentation.payments.read_header' => 'Retrieve a payment',

    'api_documentation.users_logs.breadcrumb' => 'Logs',
    'api_documentation.users_logs.title' => 'Logs API Documentation',
    'api_documentation.users_logs.header' => 'Logs',
    'api_documentation.users_logs.read_all_header' => 'Retrieve logs',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',
    'contact.input.email' => 'Email address',
    'contact.input.name' => 'Full name',
    'contact.input.subject' => 'Subject',
    'contact.input.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => '%s commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',


    'notfound.title' => 'Not found',
    'notfound.header' => 'Page not found',
    'notfound.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'notfound.button' => 'Go back home',


    'directory.breadcrumb' => 'Directory',
    'directory.title' => 'Directory',
    'directory.menu' => 'Directory',
    'directory.header' => 'Directory of users',
    'directory.subheader' => 'Discover new people with ease.',


    'links.breadcrumb' => 'Links',
    'links.title' => 'Links',
    'links.menu' => 'Links',
    'links.header' => 'Links',
    'links.create' => 'Create link',
    'links.create_biolink_block' => 'Add block',
    'links.total' => 'Total links',
    'links.clicks' => 'Total pageviews',
    'links.type' => 'Type',
    'links.is_enabled' => 'Status',
    'links.is_enabled_tooltip' => 'Change status',
    'links.no_data' => 'No links created yet..',

    'links.filters.type' => 'Type',
    'links.filters.type_biolink' => 'Biolink pages',
    'links.filters.type_link' => 'Shortened URLs',
    'links.filters.search_by_url' => 'Short URL',
    'links.filters.order_by_url' => 'Short URL',
    'links.filters.order_by_clicks' => 'Pageviews',


    'link_delete_modal.header' => 'Delete link',
    'link_delete_modal.subheader' => 'All data related to the link will be completely deleted. This action cannot be undone.',
    'link_delete_modal.success_message' => 'Link deletion was performed successfully!',


    'data.title' => 'Data',
    'data.menu' => 'Data',
    'data.breadcrumb' => 'Data',
    'data.header' => 'Data',
    'data.subheader' => 'All your data from your biolink blocks is here.',
    'data.link' => 'Data',
    'data.biolink' => 'View biolink',
    'data.no_data' => 'No existing data..',
    'data.filters.project_id' => 'Project',
    'data.filters.type' => 'Type',


    'datum_delete_modal.header' => 'Delete datum',
    'datum_delete_modal.subheader' => 'This action cannot be undone.',


    'guests_payments.title' => 'Guests payments',
    'guests_payments.menu' => 'Guests payments',
    'guests_payments.link' => 'Payments',
    'guests_payments.breadcrumb' => 'Guests payments',
    'guests_payments.header' => 'Guests payments',
    'guests_payments.subheader' => 'All your guest payment from all your biolink payment blocks.',
    'guests_payments.biolink' => 'View biolink',
    'guests_payments.no_data' => 'There are no payments made yet..',
    'guests_payments.filters.type' => 'Type',
    'guests_payments.filters.processor' => 'Processor',
    'guests_payments.filters.email' => 'Email',
    'guests_payments.filters.name' => 'Name',
    'guests_payments.filters.total_amount' => 'Total amount',


    'guests_payments_statistics.title' => 'Guests payments statistics',
    'guests_payments_statistics.menu' => 'Guests payments statistics',
    'guests_payments_statistics.link' => 'Payments statistics',
    'guests_payments_statistics.breadcrumb' => 'Guests payments statistics',
    'guests_payments_statistics.header' => '%s payments statistics',
    'guests_payments_statistics.no_data' => 'There are no payments..',
    'guests_payments_statistics.payments_label' => 'Payments',
    'guests_payments_statistics.total_amount_label' => 'Total amount',


    'payment_processors.title' => 'Payment processors',
    'payment_processors.menu' => 'Payment processors',
    'payment_processors.breadcrumb' => 'Payment processors',
    'payment_processors.header' => 'Payment processors',
    'payment_processors.subheader' => 'All your payment processors configurations for your biolink payment blocks.',
    'payment_processors.payment_processors_ids' => 'Payment processors',
    'payment_processors.create' => 'Create payment processor',
    'payment_processors.no_data' => 'No configured payment processors..',
    'payment_processors.info' => 'You can fully configure the integration after the creation.',
    'payment_processors.input.name' => 'Name',
    'payment_processors.input.processor' => 'Processor',
    'payment_processors.input.instructions' => 'Instructions',

    'payment_processors.input.paypal.mode' => 'Mode',
    'payment_processors.input.paypal.mode_sandbox' => 'Sandbox',
    'payment_processors.input.paypal.mode_live' => 'Live',
    'payment_processors.input.paypal.client_id' => 'Client ID',
    'payment_processors.input.paypal.secret' => 'Secret',
    'payment_processors.input.paypal.instructions_1' => 'Go to the <a href="https://developer.paypal.com/" target="_blank">PayPal Developer Console</a> and make sure you log into your account.',
    'payment_processors.input.paypal.instructions_2' => 'Go to REST API apps section and click the <strong>Create App button</strong>.',
    'payment_processors.input.paypal.instructions_3' => 'Add your own details for the new app and create it.',
    'payment_processors.input.paypal.instructions_4' => 'Switch to Live by clicking the button near your new App\'s Name.',
    'payment_processors.input.paypal.instructions_5' => 'Copy the <strong>Client ID</strong> and <strong>Secret</strong> and paste them here accordingly.',
    'payment_processors.input.paypal.instructions_6' => 'Scroll down to the Webhooks section, and click on the <strong>Add Webhook</strong> button.',
    'payment_processors.input.paypal.instructions_7' => 'In the <strong>Webhook URL</strong> field, add the following: <code>%s</code>',
    'payment_processors.input.paypal.instructions_8' => 'In the <strong>Event Types</strong> field, check the <strong>Payment sale completed</strong> event, and save the webhook.',

    'payment_processors.input.stripe.publishable_key' => 'Publishable Key',
    'payment_processors.input.stripe.secret_key' => 'Secret Key',
    'payment_processors.input.stripe.webhook_secret' => 'Webhook Secret',
    'payment_processors.input.stripe.instructions_1' => 'Go to the <a href="https://dashboard.stripe.com/" target="_blank">Stripe Dashboard</a> and make sure you log into your account.',
    'payment_processors.input.stripe.instructions_2' => 'Go to the <a href="https://dashboard.stripe.com/account/apikeys" target="_blank">Stripe API Keys</a> page.',
    'payment_processors.input.stripe.instructions_3' => 'Make sure your API keys are set to Live Mode so that you can accept real payments.',
    'payment_processors.input.stripe.instructions_4' => 'Copy the <strong>Publishable Key</strong> and <strong>Secret Key</strong> and paste them here accordingly.',
    'payment_processors.input.stripe.instructions_5' => 'Go to the <strong>Developers</strong> page, then go to the <strong>Webhooks</strong> page',
    'payment_processors.input.stripe.instructions_6' => 'Click on the <strong>Add endpoint</strong> button.',
    'payment_processors.input.stripe.instructions_7' => 'In the <strong>Endpoint URL</strong> field, add the following: <code>%s</code>',
    'payment_processors.input.stripe.instructions_8' => 'In the <strong>Events</strong> section, check the <strong>checkout.session.completed</strong> event, and save the webhook.',
    'payment_processors.input.stripe.instructions_9' => 'Now make sure to reveal the <strong>Signing secret</strong>, copy and paste it here accordingly.',


    'payment_processor_create.breadcrumb' => 'Create payment processor',
    'payment_processor_create.title' => 'Create payment processor',
    'payment_processor_create.header' => 'Create payment processor',


    'payment_processor_update.breadcrumb' => 'Edit payment processor',
    'payment_processor_update.title' => 'Edit payment processor',
    'payment_processor_update.header' => 'Edit payment processor',


    'payment_processor_delete_modal.header' => 'Delete payment processor',
    'payment_processor_delete_modal.subheader' => 'This action cannot be undone.',


    'projects.title' => 'Projects',
    'projects.menu' => 'Projects',
    'projects.breadcrumb' => 'Projects',
    'projects.header' => 'Projects',
    'projects.subheader' => 'The easiest way to categorize and sort your links.',
    'projects.create' => 'Create project',
    'projects.project_id' => 'Project',
    'projects.project_id_null' => 'None',
    'projects.links' => 'View shortened URLs',
    'projects.biolinks' => 'View biolink pages',
    'projects.data' => 'View data',
    'projects.qr_codes' => 'View QR codes',
    'projects.guests_payments' => 'View guests payments',

    'projects.input.name' => 'Name',
    'projects.input.color' => 'Color',
    'projects.input.color_help' => 'The color is used to help differentiate projects.',
    'projects.no_data' => 'No existing projects..',


    'project_create_modal.header' => 'Create project',


    'project_update_modal.header' => 'Edit project',
    'project_update_modal.subheader' => 'Edit your project\'s details.',


    'project_delete_modal.header' => 'Delete Project',
    'project_delete_modal.subheader' => 'All data related to the project will be completely deleted. This action cannot be undone.',


    'pixels.title' => 'Pixels',
    'pixels.menu' => 'Pixels',
    'pixels.breadcrumb' => 'Pixels',
    'pixels.header' => 'Pixels',
    'pixels.subheader' => 'Tracking pixels help you gather data from your visitors and send them to the one of the available pixel tracking websites, helping you with analytics & conversion tracking for retargeting.',
    'pixels.create' => 'Create pixel',

    'pixels.input.name' => 'Name',
    'pixels.input.type' => 'Type',
    'pixels.input.pixel' => 'Pixel ID',
    'pixels.input.pixel_help' => 'Enter the pixel id from this specific pixel type you chose.',
    'pixels.no_data' => 'No existing pixels..',


    'pixel_create_modal.header' => 'Create pixel',

    'pixel_update_modal.header' => 'Edit pixel',
    'pixel_update_modal.subheader' => 'Edit your pixel\'s details.',


    'pixel_delete_modal.header' => 'Delete Pixel',
    'pixel_delete_modal.subheader' => 'This action cannot be undone.',


    'qr_codes.link' => 'QR Code',
    'qr_codes.title' => 'QR codes',
    'qr_codes.menu' => 'QR codes',
    'qr_codes.breadcrumb' => 'QR codes',
    'qr_codes.header' => 'QR codes',
    'qr_codes.subheader' => 'Easily create customizable QR codes & remember them for later use.',
    'qr_codes.create' => 'Create QR',
    'qr_codes.print' => 'Print',
    'qr_codes.download' => 'Download',
    'qr_codes.download_svg' => 'Download SVG',
    'qr_codes.download_png' => 'Download PNG',
    'qr_codes.download_jpg' => 'Download JPG',
    'qr_codes.download_webp' => 'Download WEBP',
    'qr_codes.info' => 'Make sure to test out your configured QR code before using it in production.',

    'qr_codes.type.text' => 'Text',
    'qr_codes.type.text_description' => 'Simple and clear text embedded into a QR code.',
    'qr_codes.type.url' => 'URL',
    'qr_codes.type.url_description' => 'Send someone to a link.',
    'qr_codes.type.phone' => 'Phone',
    'qr_codes.type.phone_description' => 'Get calls from people by scanning the QR code.',
    'qr_codes.type.sms' => 'SMS',
    'qr_codes.type.sms_description' => 'Get custom SMS messages from people by scanning the QR code.',
    'qr_codes.type.email' => 'Email',
    'qr_codes.type.email_description' => 'Get custom Emails from people by scanning the QR code.',
    'qr_codes.type.whatsapp' => 'Whatsapp',
    'qr_codes.type.whatsapp_description' => 'Get custom Whatsapp messages from people by scanning the QR code.',
    'qr_codes.type.facetime' => 'Facetime',
    'qr_codes.type.facetime_description' => 'Get Facetime calls from people by scanning the QR code.',
    'qr_codes.type.location' => 'Location',
    'qr_codes.type.location_description' => 'Embed location coordinates for people to get directions more easily.',
    'qr_codes.type.wifi' => 'WiFi',
    'qr_codes.type.wifi_description' => 'Create WiFi QR codes and let people connect to your WiFi more easily.',
    'qr_codes.type.event' => 'Event',
    'qr_codes.type.event_description' => 'Generate a custom life calendar event and embed it into a QR code.',
    'qr_codes.type.crypto' => 'Crypto',
    'qr_codes.type.crypto_description' => 'Get paid in crypto from people by scanning the QR code.',
    'qr_codes.type.vcard' => 'Vcard',
    'qr_codes.type.vcard_description' => 'Embed all your contact data into a digital business card.',
    'qr_codes.type.paypal' => 'PayPal',
    'qr_codes.type.paypal_description' => 'Create PayPal direct payment links.',

    'qr_codes.table.name' => 'Name',
    'qr_codes.table.type' => 'Type',
    'qr_codes.table.datetime' => 'Created on',

    'qr_codes.input.name' => 'Name',
    'qr_codes.input.type' => 'QR Type',
    'qr_codes.input.text' => 'Text content',
    'qr_codes.input.url' => 'URL',
    'qr_codes.input.url_dynamic' => 'Dynamic QR code',
    'qr_codes.input.url_dynamic_help' => 'Enabling this will create a QR code that points to an internal short link, which will redirect to any specified link, dynamically.',
    'qr_codes.input.link_id' => 'URL',
    'qr_codes.input.phone' => 'Phone number',
    'qr_codes.input.sms' => 'Phone number',
    'qr_codes.input.sms_body' => 'Prefilled message',
    'qr_codes.input.email' => 'Email address',
    'qr_codes.input.email_subject' => 'Prefilled subject',
    'qr_codes.input.email_body' => 'Prefilled message',
    'qr_codes.input.whatsapp' => 'Phone number',
    'qr_codes.input.whatsapp_body' => 'Prefilled message',
    'qr_codes.input.facetime' => 'Phone number or email address',
    'qr_codes.input.location_latitude' => 'Latitude',
    'qr_codes.input.location_longitude' => 'Longitude',
    'qr_codes.input.wifi_ssid' => 'WiFi name (SSID)',
    'qr_codes.input.wifi_encryption' => 'Encryption',
    'qr_codes.input.wifi_encryption_nopass' => 'No encryption',
    'qr_codes.input.wifi_password' => 'Password',
    'qr_codes.input.wifi_is_hidden' => 'WiFi is hidden',
    'qr_codes.input.event' => 'Event name',
    'qr_codes.input.event_location' => 'GEO Location',
    'qr_codes.input.event_start_datetime' => 'Starts on',
    'qr_codes.input.event_end_datetime' => 'Ends on',
    'qr_codes.input.event_timezone' => 'Timezone',
    'qr_codes.input.event_url' => 'Event URL',
    'qr_codes.input.event_note' => 'Notes',
    'qr_codes.input.crypto' => 'Crypto',
    'qr_codes.input.crypto_coin' => 'Coin',
    'qr_codes.input.crypto_address' => 'Address',
    'qr_codes.input.vcard_first_name' => 'First name',
    'qr_codes.input.vcard_last_name' => 'Last name',
    'qr_codes.input.vcard_phone' => 'Phone number',
    'qr_codes.input.vcard_email' => 'Email',
    'qr_codes.input.vcard_url' => 'Website URL',
    'qr_codes.input.vcard_company' => 'Company',
    'qr_codes.input.vcard_job_title' => 'Job title',
    'qr_codes.input.vcard_birthday' => 'Birthday',
    'qr_codes.input.vcard_street' => 'Street address',
    'qr_codes.input.vcard_city' => 'City',
    'qr_codes.input.vcard_zip' => 'ZIP',
    'qr_codes.input.vcard_region' => 'Region',
    'qr_codes.input.vcard_country' => 'Country',
    'qr_codes.input.vcard_note' => 'Note',
    'qr_codes.input.vcard_socials' => 'Socials',
    'qr_codes.input.vcard_social_label' => 'Label',
    'qr_codes.input.vcard_social_value' => 'URL',
    'qr_codes.input.paypal_type' => 'Type',
    'qr_codes.input.paypal_type_buy_now' => 'Buy now',
    'qr_codes.input.paypal_type_add_to_cart' => 'Add to cart',
    'qr_codes.input.paypal_type_donation' => 'Donation',
    'qr_codes.input.paypal_email' => 'PayPal email',
    'qr_codes.input.paypal_title' => 'Product title',
    'qr_codes.input.paypal_currency' => 'Currency code',
    'qr_codes.input.paypal_price' => 'Price',
    'qr_codes.input.paypal_thank_you_url' => 'Thank you URL',
    'qr_codes.input.paypal_cancel_url' => 'Cancel URL',
    'qr_codes.input.colors' => 'Colors',
    'qr_codes.input.foreground_type' => 'Foreground type',
    'qr_codes.input.foreground_type_color' => 'Color',
    'qr_codes.input.foreground_type_gradient' => 'Gradient',
    'qr_codes.input.foreground_color' => 'Foreground color',
    'qr_codes.input.foreground_gradient_style' => 'Foreground gradient style',
    'qr_codes.input.foreground_gradient_style_vertical' => 'Vertical',
    'qr_codes.input.foreground_gradient_style_horizontal' => 'Horizontal',
    'qr_codes.input.foreground_gradient_style_diagonal' => 'Diagonal',
    'qr_codes.input.foreground_gradient_style_inverse_diagonal' => 'Inverse diagonal',
    'qr_codes.input.foreground_gradient_style_radial' => 'Radial',
    'qr_codes.input.foreground_gradient_one' => 'Foreground first color',
    'qr_codes.input.foreground_gradient_two' => 'Foreground second color',
    'qr_codes.input.background_color' => 'Background color',
    'qr_codes.input.background_color_transparency' => 'Background color transparency',
    'qr_codes.input.custom_eyes_color' => 'Custom eyes color',
    'qr_codes.input.eyes_inner_color' => 'Eyes inner color',
    'qr_codes.input.eyes_outer_color' => 'Eyes outer color',
    'qr_codes.input.branding' => 'Branding',
    'qr_codes.input.qr_code_logo' => 'Logo',
    'qr_codes.input.qr_code_logo_size' => 'Logo size',
    'qr_codes.input.options' => 'Options',
    'qr_codes.input.size' => 'Size',
    'qr_codes.input.margin' => 'Margin size',
    'qr_codes.input.ecc' => 'Error correction capability',
    'qr_codes.input.ecc_l' => 'L - low (7%)',
    'qr_codes.input.ecc_m' => 'M - medium (15%)',
    'qr_codes.input.ecc_q' => 'Q - high (25%)',
    'qr_codes.input.ecc_h' => 'H - best (30%)',
    'qr_codes.no_data' => 'No existing QR codes..',
    'qr_codes.no_data_help' => 'Start by creating your QR code.',


    'qr_code_create.breadcrumb' => 'Create QR code',
    'qr_code_create.title' => 'Create QR code',
    'qr_code_create.header' => 'Create QR code',


    'qr_code_update.breadcrumb' => 'Edit QR code',
    'qr_code_update.title' => 'Edit QR code',
    'qr_code_update.header' => 'Edit QR code',


    'qr_code_delete_modal.header' => 'Delete QR code',
    'qr_code_delete_modal.subheader' => 'This action cannot be undone.',


    'biolink_block_delete_modal.header' => 'Delete block',
    'biolink_block_delete_modal.subheader' => 'All data related to the biolink block will be completely deleted. This action cannot be undone.',
    'biolink_block_delete_modal.success_message' => 'Biolink block deletion was performed successfully!',


    'link.title' => 'Link - %s',
    'link.breadcrumb_link' => 'Link',
    'link.breadcrumb_biolink' => 'Biolink',
    'link.breadcrumb_biolink_block' => 'Biolink block',

    'link.header.header' => '%s',
    'link.header.subheader' => 'Your link is %s',
    'link.header.settings_tab' => 'Settings',
    'link.header.links_tab' => 'Blocks',

    'link.settings.header' => 'Settings',
    'link.settings.link' => 'Settings',
    'link.settings.breadcrumb' => 'Settings',
    'link.settings.location_url' => 'Long URL',
    'link.settings.location_url_placeholder' => 'https://domain.com/example',
    'link.settings.url' => 'Short URL',
    'link.settings.url_placeholder' => 'your-custom-alias',
    'link.settings.url_help' => 'Leave empty for a random generated one.',
    'link.settings.pixels_ids' => 'Pixels',
    'link.settings.schedule' => 'Schedule',
    'link.settings.schedule_help' => 'Set an exact date when the link will work.',
    'link.settings.start_date' => 'Start Date',
    'link.settings.end_date' => 'End Date',
    'link.settings.text_color' => 'Text Color',
    'link.settings.background_type' => 'Background',
    'link.settings.background_type_preset' => 'Simple gradients',
    'link.settings.background_type_preset_abstract' => 'Abstract gradients',
    'link.settings.background_type_color' => 'Custom Color',
    'link.settings.background_type_gradient' => 'Custom Gradient',
    'link.settings.background_type_gradient_color_one' => 'Color One',
    'link.settings.background_type_gradient_color_two' => 'Color Two',
    'link.settings.background_type_image' => 'Custom Image',
    'link.settings.favicon' => 'Favicon',
    'link.settings.favicon_help' => 'Set a custom favicon for your biolink page. png, gif or ico accepted.',
    'link.settings.verified_header' => 'Verified',
    'link.settings.verified_help' => 'Contact us to submit a verification request.',
    'link.settings.verified_location' => 'Location',
    'link.settings.verified_location_top' => 'Top',
    'link.settings.verified_location_bottom' => 'Bottom',
    'link.settings.branding_header' => 'Branding',
    'link.settings.display_branding' => 'Display branding',

    'link.settings.branding.name' => 'Branding name',
    'link.settings.branding.name_help' => 'Leave empty to have the default site branding.',
    'link.settings.branding.url' => 'Branding URL',
    'link.settings.pixels_header' => 'Pixels',
    'link.settings.seo_header' => 'Seo',
    'link.settings.seo_block' => 'Block Search Engine Indexing',
    'link.settings.seo_block_help' => 'Block your biolink page from being indexed by search engines.',
    'link.settings.seo_title' => 'Page title',
    'link.settings.seo_title_help' => 'Completely change the page title to a custom one that you are setting here.',
    'link.settings.seo_meta_description' => 'Meta description',
    'link.settings.seo_meta_description_help' => 'Set a custom meta description for your biolink page to rank better in search engines.',
    'link.settings.seo_image' => 'OpenGraph Image',
    'link.settings.seo_image_help' => 'Set a custom OpenGraph/Twitter Image for your biolink page to display a link preview. jpg, jpeg, png or gif accepted.',
    'link.settings.utm_header' => 'UTM Parameters',
    'link.settings.utm_medium' => 'Medium',
    'link.settings.utm_campaign' => 'The campaign will be automatically set for each link in particular based on the name of the link.',
    'link.settings.utm_source' => 'Source',
    'link.settings.fonts_header' => 'Fonts',
    'link.settings.font' => 'Font',
    'link.settings.font_size' => 'Font size',
    'link.settings.protection_header' => 'Protection',
    'link.settings.password' => 'Password',
    'link.settings.password_help' => 'Require users to enter a password before accessing the link.',
    'link.settings.sensitive_content' => 'Sensitive content warning',
    'link.settings.sensitive_content_help' => 'Require users to confirm that they want to access your link and letting them know that the link might be sensitive.',
    'link.settings.leap_link' => 'Leap Link URL',
    'link.settings.leap_link_help' => 'Fully redirect all users that access the biolink page to this URL. Leave empty to disable the feature.',
    'link.settings.temporary_url_header' => 'Temporary URL',
    'link.settings.clicks_limit' => 'Clicks limit',
    'link.settings.clicks_limit_help' => 'Only allow the link to work for a certain amount of clicks.',
    'link.settings.expiration_url' => 'Expiration URL',
    'link.settings.expiration_url_help' => 'Visitors will be redirected to this URL after the main link expires.',
    'link.settings.targeting_header' => 'Targeting',
    'link.settings.targeting_type' => 'Targeting type',
    'link.settings.targeting_type_null' => 'None',
    'link.settings.targeting_type_country_code' => 'Country',
    'link.settings.targeting_type_country_code_help' => 'Send visitors to different URLs based on their country location.',
    'link.settings.targeting_type_device_type' => 'Device type',
    'link.settings.targeting_type_device_type_help' => 'Send visitors to different URLs based on the device that they are using.',
    'link.settings.targeting_type_browser_language' => 'Browser language',
    'link.settings.targeting_type_browser_language_help' => 'Send visitors to different URLs based on their main browser language.',
    'link.settings.targeting_type_rotation' => 'Rotation & A/B Testing',
    'link.settings.targeting_type_rotation_help' => 'Randomly & equally split the visits to multiple URLs. Helpful when running A/B tests for example.',
    'link.settings.targeting_type_percentage' => 'Percentage chances',
    'link.settings.targeting_type_os_name' => 'Operating System',
    'link.settings.targeting_type_os_name_help' => 'Send visitors to different URLs based on the device operating system that they are using.',
    'link.settings.advanced_header' => 'Advanced',
    'link.settings.custom_css' => 'Custom CSS',
    'link.settings.custom_css_help' => 'Add your own CSS for more customizability.',
    'link.settings.custom_js' => 'Custom JS',
    'link.settings.custom_js_help' => 'Add your own JavaScript code, like a custom tracking code, help chat..etc',
    'link.settings.customization_header' => 'Customization',
    'link.settings.biolink_theme_id' => 'Theme',
    'link.settings.biolink_theme_id_null' => 'Custom',

    'link.biolink_blocks.link_sort' => 'Drag & drop to reorder',
    'link.biolink_blocks.no_data' => 'No blocks for now..',
    'link.biolink_blocks.is_enabled_tooltip' => 'Change status',

    'link.statistics.breadcrumb' => 'Statistics',
    'link.statistics.header' => 'Statistics',
    'link.statistics.link' => 'Statistics',
    'link.statistics.pageviews' => 'Pageviews',
    'link.statistics.visitors' => 'Visitors',
    'link.statistics.no_data' => 'There are no statistics available for this date range',
    'link.statistics.no_data_help' => 'Wait until you get some traffic and come back.',
    'link.statistics.overview' => 'Overview',
    'link.statistics.overview_help' => '',
    'link.statistics.view_more' => 'View more',
    'link.statistics.country' => 'Countries',
    'link.statistics.country_help' => 'Discover the countries that your visitors are from.',
    'link.statistics.country_unknown' => 'Unknown',
    'link.statistics.city' => 'Cities of %s',
    'link.statistics.city_help' => 'Discover the cities that your visitors are from.',
    'link.statistics.city_unknown' => 'Unknown',
    'link.statistics.os' => 'Operating Systems',
    'link.statistics.os_help' => 'Discover the operating systems that your visitors are using.',
    'link.statistics.os_unknown' => 'Unknown',
    'link.statistics.browser' => 'Browsers',
    'link.statistics.browser_help' => 'Discover the browsers that your visitors are using.',
    'link.statistics.browser_unknown' => 'Unknown',
    'link.statistics.language' => 'Languages',
    'link.statistics.language_help' => 'Discover the browser languages that your visitors are having.',
    'link.statistics.language_unknown' => 'Unknown',
    'link.statistics.device' => 'Devices',
    'link.statistics.device_help' => 'Discover the devices that your visitors are using.',
    'link.statistics.device_unknown' => 'Unknown',
    'link.statistics.device_desktop' => 'Desktop',
    'link.statistics.device_tablet' => 'Tablet',
    'link.statistics.device_mobile' => 'Mobile',
    'link.statistics.referrer_host' => 'Referrers',
    'link.statistics.referrer_path' => '%s referrer paths',
    'link.statistics.referrer_help' => 'Discover where your traffic is coming from.',
    'link.statistics.referrer_direct' => 'Direct',
    'link.statistics.referrer_qr' => 'QR Code',
    'link.statistics.utms' => 'UTMs',
    'link.statistics.utms_help' => 'Discover how your UTM marketing campaigns are performing.',
    'link.statistics.utm_medium' => '%s utm mediums',
    'link.statistics.utm_campaign' => '%s / %s utm sources',

    'link.password.title' => 'Password protected',
    'link.password.header' => 'Password protected',
    'link.password.subheader' => 'You must input the correct password to continue. Your password will be remembered for 30 days.',
    'link.password.input' => 'Password',
    'link.password.error_message' => 'The password is incorrect!',

    'link.sensitive_content.title' => 'Sensitive content',
    'link.sensitive_content.header' => 'Sensitive content',
    'link.sensitive_content.subheader' => 'This link may contain sensitive content which some viewers may find offensive or disturbing.',
    'link.sensitive_content.button' => 'Accept',

    'link.error_message.blacklisted_url' => 'This custom URL is not available for usage.',
    'link.error_message.blacklisted_domain' => 'This domain has been blacklisted, you can\'t use it.',
    'link.error_message.blacklisted_keyword' => 'This custom URL is blacklisted.',
    'link.error_message.blacklisted_location_url' => 'This URL has been blacklisted, you can\'t use it.',
    'link.error_message.invalid_location_url' => 'Your entered link has an invalid format. Maybe you\'re missing the https:// from the URL?',
    'link.error_message.invalid_location_url_embed' => 'Your entered link is invalid for embedding.',

    'link.biolink.name' => 'Biolink page',
    'link.biolink.icon' => 'fa fa-fw fa-hashtag',
    'link.biolink.color' => '#383eb2',
    'link.biolink.image_alt' => 'Avatar',
    'link.biolink.verified' => 'Verified User',

    'link.biolink.blocks.link' => 'Link',
    'link.biolink.blocks.heading' => 'Heading',
    'link.biolink.blocks.paragraph' => 'Paragraph',
    'link.biolink.blocks.avatar' => 'Avatar',
    'link.biolink.blocks.socials' => 'Socials',
    'link.biolink.blocks.image' => 'Image',
    'link.biolink.blocks.twitch' => 'Twitch',
    'link.biolink.blocks.youtube' => 'YouTube',
    'link.biolink.blocks.soundcloud' => 'SoundCloud',
    'link.biolink.blocks.vimeo' => 'Vimeo',
    'link.biolink.blocks.spotify' => 'Spotify',
    'link.biolink.blocks.tiktok' => 'TikTok',
    'link.biolink.blocks.applemusic' => 'Apple Music',
    'link.biolink.blocks.tidal' => 'Tidal',
    'link.biolink.blocks.anchor' => 'Anchor FM',
    'link.biolink.blocks.twitter_tweet' => 'Twitter Tweet',
    'link.biolink.blocks.instagram_media' => 'Instagram Media',
    'link.biolink.blocks.rss_feed' => 'RSS Feed',
    'link.biolink.blocks.custom_html' => 'Custom HTML',
    'link.biolink.blocks.vcard' => 'VCard',
    'link.biolink.blocks.image_grid' => 'Image Grid',
    'link.biolink.blocks.divider' => 'Divider',
    'link.biolink.blocks.mail' => 'Mail signup',
    'link.biolink.blocks.faq' => 'FAQ',
    'link.biolink.blocks.discord' => 'Discord Server',
    'link.biolink.blocks.facebook' => 'Facebook Post',
    'link.biolink.blocks.reddit' => 'Reddit Post',
    'link.biolink.blocks.audio' => 'Audio',
    'link.biolink.blocks.video' => 'Video',
    'link.biolink.blocks.file' => 'File',
    'link.biolink.blocks.countdown' => 'Countdown',
    'link.biolink.blocks.cta' => 'Call to action',
    'link.biolink.blocks.external_item' => 'External item',
    'link.biolink.blocks.share' => 'Share',
    'link.biolink.blocks.youtube_feed' => 'Youtube Feed',
    'link.biolink.blocks.paypal' => 'PayPal',
    'link.biolink.blocks.phone_collector' => 'Phone collector',
    'link.biolink.blocks.donation' => 'Donation',
    'link.biolink.blocks.product' => 'Product',
    'link.biolink.blocks.service' => 'Service',

    'link.link.name' => 'Shortened URL',
    'link.link.icon' => 'fa-link',
    'link.link.color' => '#38b2ac',


    'create_link_modal.header' => 'Shorten URL',
    'create_link_modal.input.location_url' => 'Long URL',
    'create_link_modal.input.location_url_placeholder' => 'https://domain.com/example',
    'create_link_modal.input.url' => 'Short URL',
    'create_link_modal.input.url_placeholder_custom' => 'your-custom-alias',
    'create_link_modal.input.url_placeholder' => 'randomly generated alias',
    'create_link_modal.input.url_help' => 'Leave empty for a random generated one.',
    'create_link_modal.input.submit' => 'Shorten URL',
    'create_link_modal.error_message.url_exists' => 'Your selected Short URL already exists. Please choose a different one.',
    'create_link_modal.error_message.main_domain_is_disabled' => 'You are not allowed to use the main domain for shortening links.',


    'create_biolink_modal.header' => 'Create biolink page',
    'create_biolink_modal.input.url' => 'Biolink URL',
    'create_biolink_modal.input.url_placeholder_custom' => 'your-custom-alias',
    'create_biolink_modal.input.url_placeholder' => 'randomly generated alias',
    'create_biolink_modal.input.url_help' => 'Leave empty for a random generated one.',
    'create_biolink_modal.input.submit' => 'Create biolink page',


    'create_biolink_modal.error_message.url_exists' => 'Your selected Biolink URL already exists. Please choose a different one.',
    'create_biolink_modal.error_message.main_domain_is_disabled' => 'You are not allowed to use the main domain for biolink pages.',


    'create_biolink_link_modal.header' => 'Add a link button',
    'create_biolink_link_modal.button_header' => 'Button customization settings',
    'create_biolink_link_modal.input.url_help' => 'Leave empty for a random generated one.',
    'create_biolink_link_modal.input.location_url' => 'Destination URL',
    'create_biolink_link_modal.input.location_url_placeholder' => 'https://domain.com/demo/url-demo',
    'create_biolink_link_modal.input.open_in_new_tab' => 'Open in new tab',
    'create_biolink_link_modal.input.name' => 'Name',
    'create_biolink_link_modal.input.text_color' => 'Text Color',
    'create_biolink_link_modal.input.background_color' => 'Background Color',
    'create_biolink_link_modal.input.icon' => 'Icon',
    'create_biolink_link_modal.input.icon_placeholder' => 'ex: fab fa-instagram',
    'create_biolink_link_modal.input.icon_help' => '<a href="https://fontawesome.com/v5/search?m=free" target="_blank">FontAwesome</a> icon class, leave empty for no icon.',
    'create_biolink_link_modal.input.image' => 'Image Thumbnail URL',
    'create_biolink_link_modal.input.image_placeholder' => 'ex: https://domain.com/image.jpg',
    'create_biolink_link_modal.input.image_help' => 'Leave empty for no image thumbnail.',
    'create_biolink_link_modal.input.image_alt' => 'Image alt',
    'create_biolink_link_modal.input.image_alt_help' => 'Image description for accessibility & SEO purposes.',
    'create_biolink_link_modal.input.border_width' => 'Border width',
    'create_biolink_link_modal.input.border_color' => 'Border color',
    'create_biolink_link_modal.input.border_radius' => 'Border radius',
    'create_biolink_link_modal.input.border_radius_straight' => 'Straight',
    'create_biolink_link_modal.input.border_radius_round' => 'Round',
    'create_biolink_link_modal.input.border_radius_rounded' => 'Rounded',
    'create_biolink_link_modal.input.border_style' => 'Border style',
    'create_biolink_link_modal.input.border_style_solid' => 'Solid',
    'create_biolink_link_modal.input.border_style_dashed' => 'Dashed',
    'create_biolink_link_modal.input.border_style_double' => 'Double',
    'create_biolink_link_modal.input.border_style_inset' => 'Inset',
    'create_biolink_link_modal.input.border_style_outset' => 'Outset',
    'create_biolink_link_modal.input.animation' => 'Animation',
    'create_biolink_link_modal.input.animation_runs' => 'Animation runs',
    'create_biolink_link_modal.input.animation_runs_infinite' => 'Infinite',


    'create_biolink_heading_modal.header' => 'Add a heading',
    'create_biolink_heading_modal.heading_type' => 'Type',
    'create_biolink_heading_modal.text' => 'Text',
    'create_biolink_heading_modal.text_color' => 'Color',


    'create_biolink_paragraph_modal.header' => 'Add a paragraph',
    'create_biolink_paragraph_modal.text' => 'Text',
    'create_biolink_paragraph_modal.text_color' => 'Color',


    'create_biolink_avatar_modal.header' => 'Add an avatar',
    'create_biolink_avatar_modal.image' => 'Image',
    'create_biolink_avatar_modal.size' => 'Size',
    'create_biolink_avatar_modal.border_radius' => 'Border Radius',
    'create_biolink_avatar_modal.border_radius_straight' => 'Straight',
    'create_biolink_avatar_modal.border_radius_round' => 'Round',
    'create_biolink_avatar_modal.border_radius_rounded' => 'Rounded',

    'create_biolink_socials_modal.header' => 'Add social links',
    'create_biolink_socials_modal.color' => 'Color',


    'create_biolink_socials_modal.socials.email.name' => 'Email',
    'create_biolink_socials_modal.socials.email.placeholder' => 'email@domain.com',

    'create_biolink_socials_modal.socials.tel.name' => 'Telephone',
    'create_biolink_socials_modal.socials.tel.placeholder' => '+00000000000',

    'create_biolink_socials_modal.socials.telegram.name' => 'Telegram',
    'create_biolink_socials_modal.socials.telegram.placeholder' => 'telegram-username',

    'create_biolink_socials_modal.socials.whatsapp.name' => 'Whatsapp',
    'create_biolink_socials_modal.socials.whatsapp.placeholder' => '+00000000000',

    'create_biolink_socials_modal.socials.facebook.name' => 'Facebook',
    'create_biolink_socials_modal.socials.facebook.placeholder' => 'facebook-page',

    'create_biolink_socials_modal.socials.facebook-messenger.name' => 'Facebook Messenger',
    'create_biolink_socials_modal.socials.facebook-messenger.placeholder' => 'facebook-page',

    'create_biolink_socials_modal.socials.instagram.name' => 'Instagram',
    'create_biolink_socials_modal.socials.instagram.placeholder' => 'Instagram username',

    'create_biolink_socials_modal.socials.twitter.name' => 'Twitter',
    'create_biolink_socials_modal.socials.twitter.placeholder' => 'Twitter username',

    'create_biolink_socials_modal.socials.tiktok.name' => 'TikTok',
    'create_biolink_socials_modal.socials.tiktok.placeholder' => 'TikTok username',

    'create_biolink_socials_modal.socials.youtube.name' => 'YouTube Channel',
    'create_biolink_socials_modal.socials.youtube.placeholder' => 'Channel ID',

    'create_biolink_socials_modal.socials.soundcloud.name' => 'SoundCloud',
    'create_biolink_socials_modal.socials.soundcloud.placeholder' => 'SoundCloud username',

    'create_biolink_socials_modal.socials.linkedin.name' => 'LinkedIn',
    'create_biolink_socials_modal.socials.linkedin.placeholder' => 'Linked In Profile',

    'create_biolink_socials_modal.socials.spotify.name' => 'Spotify',
    'create_biolink_socials_modal.socials.spotify.placeholder' => 'Spotify username',

    'create_biolink_socials_modal.socials.pinterest.name' => 'Pinterest',
    'create_biolink_socials_modal.socials.pinterest.placeholder' => 'Pinterest username',

    'create_biolink_socials_modal.socials.snapchat.name' => 'Snapchat',
    'create_biolink_socials_modal.socials.snapchat.placeholder' => 'Snapchat username',

    'create_biolink_socials_modal.socials.twitch.name' => 'Twitch',
    'create_biolink_socials_modal.socials.twitch.placeholder' => 'Twitch username',

    'create_biolink_socials_modal.socials.discord.name' => 'Discord',
    'create_biolink_socials_modal.socials.discord.placeholder' => 'Discord username',

    'create_biolink_image_modal.header' => 'Add an image',
    'create_biolink_image_modal.image' => 'Image',

    'create_biolink_youtube_modal.header' => 'Add a YouTube video',
    'create_biolink_youtube_modal.subheader' => 'Paste in your YouTube video URL and we will show it as a video on your profile.',
    'create_biolink_youtube_modal.location_url' => 'YouTube Video URL',
    'create_biolink_youtube_modal.location_url_placeholder' => 'https://www.youtube.com/watch?v=2a8PgqWrc_4',

    'create_biolink_twitch_modal.header' => 'Add a Twitch video',
    'create_biolink_twitch_modal.subheader' => 'Paste in your Twitch URL and we will show it as a video on your profile.',
    'create_biolink_twitch_modal.location_url' => 'Twitch URL',
    'create_biolink_twitch_modal.location_url_placeholder' => 'https://www.twitch.tv/dota2ti',

    'create_biolink_vimeo_modal.header' => 'Add a Vimeo video',
    'create_biolink_vimeo_modal.subheader' => 'Paste in your Vimeo URL and we will show it as a video on your profile.',
    'create_biolink_vimeo_modal.location_url' => 'Vimeo URL',
    'create_biolink_vimeo_modal.location_url_placeholder' => 'https://vimeo.com/43338103',

    'create_biolink_soundcloud_modal.header' => 'Add a Soundcloud song',
    'create_biolink_soundcloud_modal.subheader' => 'Paste in your Soundcloud URL and we will show it as a playable song on your profile.',
    'create_biolink_soundcloud_modal.location_url' => 'Soundcloud URL',
    'create_biolink_soundcloud_modal.location_url_placeholder' => 'https://soundcloud.com/octobersveryown/duppy-freestyle',

    'create_biolink_applemusic_modal.header' => 'Add an Apple Music song',
    'create_biolink_applemusic_modal.subheader' => 'Paste in your Apple Music URL and we will show it as a playable song on your profile.',
    'create_biolink_applemusic_modal.location_url' => 'Apple Music URL',
    'create_biolink_applemusic_modal.location_url_placeholder' => 'https://music.apple.com/us/album/evermore/1544268281',

    'create_biolink_tidal_modal.header' => 'Add a Tidal song',
    'create_biolink_tidal_modal.subheader' => 'Paste in your Tidal Song URL and we will show it as a playable song on your profile.',
    'create_biolink_tidal_modal.location_url' => 'Tidal Music URL',
    'create_biolink_tidal_modal.location_url_placeholder' => 'https://tidal.com/browse/track/18445266',

    'create_biolink_anchor_modal.header' => 'Add an Anchor FM podcast',
    'create_biolink_anchor_modal.subheader' => 'Paste in your Anchor FM Podcast URL and we will show it as a playable podcast on your profile.',
    'create_biolink_anchor_modal.location_url' => 'Anchor FM Podcast URL',
    'create_biolink_anchor_modal.location_url_placeholder' => 'https://anchor.fm/beachtoosandy/episodes/107-Reviews-of-Driving-Schools-ensejl',

    'create_biolink_twitter_tweet_modal.header' => 'Add a Twitter Tweet',
    'create_biolink_twitter_tweet_modal.subheader' => 'Paste in your Tweet URL and we will show it on your profile.',
    'create_biolink_twitter_tweet_modal.location_url' => 'Twitter Tweet URL',
    'create_biolink_twitter_tweet_modal.location_url_placeholder' => 'https://twitter.com/naval/status/1002103360646823936',

    'create_biolink_instagram_media_modal.header' => 'Add an Instagram Media',
    'create_biolink_instagram_media_modal.subheader' => 'Paste in your Instagram Post, Reel or IGTV URL and we will show it on your profile.',
    'create_biolink_instagram_media_modal.location_url' => 'Instagram Media URL',
    'create_biolink_instagram_media_modal.location_url_placeholder' => 'https://www.instagram.com/p/CI1pQoDjZTz',

    'create_biolink_spotify_modal.header' => 'Add a Spotify Song / Album',
    'create_biolink_spotify_modal.subheader' => 'Paste in your Spotify Song, Album, Show or Episode URL and we will show it as a player on your profile.',
    'create_biolink_spotify_modal.location_url' => 'Spotify URL',
    'create_biolink_spotify_modal.location_url_placeholder' => 'https://open.spotify.com/track/5ry2OE6R2zPQFDO85XkgRb',

    'create_biolink_tiktok_modal.header' => 'Add a TikTok video',
    'create_biolink_tiktok_modal.subheader' => 'Paste in your TikTok Video URL and we will show it as a video on your profile.',
    'create_biolink_tiktok_modal.location_url' => 'TikTok Video URL',
    'create_biolink_tiktok_modal.location_url_placeholder' => 'https://www.tiktok.com/@charlidamelio/video/6808693617306111237',

    'create_biolink_mail_modal.header' => 'Add a sign up form',
    'create_biolink_mail_modal.subheader' => 'Capture email sign ups with ease.',
    'create_biolink_mail_modal.mail_header' => 'Form settings',
    'create_biolink_mail_modal.email_placeholder' => 'Email placeholder',
    'create_biolink_mail_modal.name_placeholder' => 'Name placeholder',
    'create_biolink_mail_modal.button_text' => 'Button Text',
    'create_biolink_mail_modal.success_text' => 'Thank you message',
    'create_biolink_mail_modal.show_agreement' => 'Show Agreement',
    'create_biolink_mail_modal.show_agreement_help' => 'Require the user to confirm his agreement by ticking a checkbox.',
    'create_biolink_mail_modal.agreement_url' => 'Agreement URL',
    'create_biolink_mail_modal.agreement_text' => 'Agreement Text',
    'create_biolink_mail_modal.thank_you_url' => 'Thank you URL',
    'create_biolink_mail_modal.thank_you_url_help' => 'Redirect the user to a specific URL after submitting the form. Leave empty to disable.',
    'create_biolink_mail_modal.mailchimp_api' => 'Mailchimp API Key',
    'create_biolink_mail_modal.mailchimp_api_help' => 'Leave empty to disable mailchimp integration. How to get these details: <a href="https://mailchimp.com/developer/guides/manage-subscribers-with-the-mailchimp-api/#Before_you_start" target="_blank">MailChimp Documentation</a>',
    'create_biolink_mail_modal.mailchimp_api_list' => 'Mailchimp List',
    'create_biolink_mail_modal.mailchimp_api_list_help' => '',
    'create_biolink_mail_modal.email_placeholder_default' => 'email@domain.com',
    'create_biolink_mail_modal.name_placeholder_default' => 'Your full name',
    'create_biolink_mail_modal.button_text_default' => 'Sign up',
    'create_biolink_mail_modal.success_text_default' => 'Thank you for signing up!',


    'create_biolink_rss_feed_modal.header' => 'Add an RSS Feed',
    'create_biolink_rss_feed_modal.subheader' => 'Display a simple dynamic RSS Feed on your page.',
    'create_biolink_rss_feed_modal.location_url' => 'RSS Feed URL',
    'create_biolink_rss_feed_modal.amount' => 'Amount of posts to show',


    'create_biolink_custom_html_modal.header' => 'Add custom HTML',
    'create_biolink_custom_html_modal.subheader' => 'Add any type of custom HTML to display exactly what you need to.',
    'create_biolink_custom_html_modal.html' => 'Custom HTML',


    'create_biolink_vcard_modal.header' => 'Add VCard',
    'create_biolink_vcard_modal.subheader' => 'Add a VCard download button to your profile.',
    'create_biolink_vcard_modal.vcard_header' => 'Vcard settings',
    'create_biolink_vcard_modal.vcard_first_name' => 'First name',
    'create_biolink_vcard_modal.vcard_last_name' => 'Last name',
    'create_biolink_vcard_modal.vcard_phone' => 'Phone number',
    'create_biolink_vcard_modal.vcard_email' => 'Email',
    'create_biolink_vcard_modal.vcard_url' => 'Website URL',
    'create_biolink_vcard_modal.vcard_company' => 'Company',
    'create_biolink_vcard_modal.vcard_job_title' => 'Job title',
    'create_biolink_vcard_modal.vcard_birthday' => 'Birthday',
    'create_biolink_vcard_modal.vcard_street' => 'Street address',
    'create_biolink_vcard_modal.vcard_city' => 'City',
    'create_biolink_vcard_modal.vcard_zip' => 'ZIP',
    'create_biolink_vcard_modal.vcard_region' => 'Region',
    'create_biolink_vcard_modal.vcard_country' => 'Country',
    'create_biolink_vcard_modal.vcard_note' => 'Note',
    'create_biolink_vcard_modal.vcard_socials' => 'Socials',
    'create_biolink_vcard_modal.vcard_social_label' => 'Label',
    'create_biolink_vcard_modal.vcard_social_value' => 'URL',


    'create_biolink_image_grid_modal.header' => 'Add an image grid',
    'create_biolink_image_grid_modal.image' => 'Image',


    'create_biolink_divider_modal.header' => 'Add a space divider',
    'create_biolink_divider_modal.margin_top' => 'Margin top',
    'create_biolink_divider_modal.margin_bottom' => 'Margin bottom',


    'create_biolink_faq_modal.header' => 'Add an FAQ block',
    'create_biolink_faq_modal.title' => 'Title',
    'create_biolink_faq_modal.content' => 'Content',


    'create_biolink_discord_modal.header' => 'Add a Discord Server Widget',
    'create_biolink_discord_modal.server_id' => 'Server Id',


    'create_biolink_facebook_modal.header' => 'Add a Facebook Post',
    'create_biolink_facebook_modal.location_url' => 'Facebook Post/Video URL',


    'create_biolink_reddit_modal.header' => 'Add a Reddit Post',
    'create_biolink_reddit_modal.location_url' => 'Reddit Post URL',


    'create_biolink_audio_modal.header' => 'Add an audio file',
    'create_biolink_audio_modal.file' => 'Audio file',
    'create_biolink_audio_modal.file_help' => '',


    'create_biolink_video_modal.header' => 'Add a video file',
    'create_biolink_video_modal.file' => 'Video file',
    'create_biolink_video_modal.file_help' => '',
    'create_biolink_video_modal.poster_url' => 'Thumbnail Image URL',


    'create_biolink_file_modal.header' => 'Add a file block',
    'create_biolink_file_modal.file' => 'File',
    'create_biolink_file_modal.file_help' => '',


    'create_biolink_countdown_modal.header' => 'Add a countdown timer',
    'create_biolink_countdown_modal.end_date' => 'End date',
    'create_biolink_countdown_modal.theme' => 'Theme',
    'create_biolink_countdown_modal.theme_light' => 'Light',
    'create_biolink_countdown_modal.theme_dark' => 'Dark',


    'create_biolink_cta_modal.header' => 'Add a call to action button',
    'create_biolink_cta_modal.type' => 'Type',
    'create_biolink_cta_modal.type_email' => 'Email',
    'create_biolink_cta_modal.type_call' => 'Call',
    'create_biolink_cta_modal.type_sms' => 'SMS',
    'create_biolink_cta_modal.type_facetime' => 'Facetime',
    'create_biolink_cta_modal.value_email' => 'Email address',
    'create_biolink_cta_modal.value_call' => 'Phone number',
    'create_biolink_cta_modal.value_sms' => 'Phone number',
    'create_biolink_cta_modal.value_facetime' => 'Phone number or email address',


    'create_biolink_external_item_modal.header' => 'Add an external item',
    'create_biolink_external_item_modal.location_url' => 'Item URL',
    'create_biolink_external_item_modal.description' => 'Description',
    'create_biolink_external_item_modal.price' => 'Price',
    'create_biolink_external_item_modal.price_placeholder' => '20 USD',
    'create_biolink_external_item_modal.name_text_color' => 'Name color',
    'create_biolink_external_item_modal.description_text_color' => 'Description color',
    'create_biolink_external_item_modal.price_text_color' => 'Price color',


    'create_biolink_share_modal.header' => 'Add a share button',


    'create_biolink_youtube_feed_modal.header' => 'Add an YouTube Feed',
    'create_biolink_youtube_feed_modal.subheader' => 'Display your latest youtube videos dynamic on your page.',
    'create_biolink_youtube_feed_modal.channel_id' => 'YouTube Channel Id',
    'create_biolink_youtube_feed_modal.amount' => 'Amount of videos to show',


    'create_biolink_paypal_modal.header' => 'Add a PayPal payment button',
    'create_biolink_paypal_modal.subheader' => 'Redirect your users to pay via PayPal for a custom product.',
    'create_biolink_paypal_modal.type' => 'Type',
    'create_biolink_paypal_modal.type_buy_now' => 'Buy now',
    'create_biolink_paypal_modal.type_add_to_cart' => 'Add to cart',
    'create_biolink_paypal_modal.type_donation' => 'Donation',
    'create_biolink_paypal_modal.email' => 'PayPal email',
    'create_biolink_paypal_modal.title' => 'Product title',
    'create_biolink_paypal_modal.price' => 'Price',
    'create_biolink_paypal_modal.currency' => 'Currency code',
    'create_biolink_paypal_modal.currency_placeholder' => 'EUR',
    'create_biolink_paypal_modal.thank_you_url' => 'Thank you URL',
    'create_biolink_paypal_modal.cancel_url' => 'Cancelled payment URL',


    'create_biolink_phone_collector_modal.header' => 'Add a phone collector form',
    'create_biolink_phone_collector_modal.subheader' => 'Capture phone numbers with ease.',
    'create_biolink_phone_collector_modal.phone_collector_header' => 'Form settings',
    'create_biolink_phone_collector_modal.phone_placeholder' => 'Phone placeholder',
    'create_biolink_phone_collector_modal.name_placeholder' => 'Name placeholder',
    'create_biolink_phone_collector_modal.button_text' => 'Button Text',
    'create_biolink_phone_collector_modal.success_text' => 'Thank you message',
    'create_biolink_phone_collector_modal.show_agreement' => 'Show Agreement',
    'create_biolink_phone_collector_modal.show_agreement_help' => 'Require the user to confirm his agreement by ticking a checkbox.',
    'create_biolink_phone_collector_modal.agreement_url' => 'Agreement URL',
    'create_biolink_phone_collector_modal.agreement_text' => 'Agreement Text',
    'create_biolink_phone_collector_modal.thank_you_url' => 'Thank you URL',
    'create_biolink_phone_collector_modal.thank_you_url_help' => 'Redirect the user to a specific URL after submitting the form. Leave empty to disable.',
    'create_biolink_phone_collector_modal.phone_placeholder_default' => '+401234567890',
    'create_biolink_phone_collector_modal.name_placeholder_default' => 'Your full name',
    'create_biolink_phone_collector_modal.button_text_default' => 'Sign up',
    'create_biolink_phone_collector_modal.success_text_default' => 'Thank you for signing up!',


    'create_biolink_donation_modal.header' => 'Add Donation',
    'create_biolink_donation_modal.subheader' => 'Add a Donation button to your profile.',
    'create_biolink_donation_modal.donation_header' => 'Donation settings',
    'create_biolink_donation_modal.title' => 'Donation title',
    'create_biolink_donation_modal.description' => 'Donation description',
    'create_biolink_donation_modal.prefilled_amount' => 'Prefilled amount',
    'create_biolink_donation_modal.minimum_amount' => 'Minimum amount',
    'create_biolink_donation_modal.currency' => 'Currency code',
    'create_biolink_donation_modal.currency_help' => 'Currency code, such as USD, EUR, AUD...etc. Make sure that it is compatible with the payment processor you choose to use.',
    'create_biolink_donation_modal.allow_custom_amount' => 'Allow custom amount',
    'create_biolink_donation_modal.allow_message' => 'Allow messages',
    'create_biolink_donation_modal.allow_message_help' => 'You will be able to receive a small message from people who donate.',
    'create_biolink_donation_modal.thank_you_title' => 'Thank you title',
    'create_biolink_donation_modal.thank_you_description' => 'Thank you description',


    'biolink_donation_modal.amount' => 'Amount',
    'biolink_donation_modal.message' => 'Your message',
    'biolink_donation_modal.payment_processor' => 'Pay via',
    'biolink_donation_modal.submit' => 'Donate',


    'create_biolink_product_modal.header' => 'Add Product',
    'create_biolink_product_modal.subheader' => 'Add a Product purchase button to your profile.',
    'create_biolink_product_modal.product_header' => 'Product settings',
    'create_biolink_product_modal.file' => 'Product file',
    'create_biolink_product_modal.title' => 'Product title',
    'create_biolink_product_modal.description' => 'Product description',
    'create_biolink_product_modal.price' => 'Price',
    'create_biolink_product_modal.minimum_price' => 'Minimum price',
    'create_biolink_product_modal.currency' => 'Currency code',
    'create_biolink_product_modal.currency_help' => 'Currency code, such as USD, EUR, AUD...etc. Make sure that it is compatible with the payment processor you choose to use.',
    'create_biolink_product_modal.allow_custom_price' => 'Allow custom amount',
    'create_biolink_product_modal.thank_you_title' => 'Thank you title',
    'create_biolink_product_modal.thank_you_description' => 'Thank you description',


    'biolink_product_modal.price' => 'Price',
    'biolink_product_modal.email' => 'Email',
    'biolink_product_modal.email_help' => 'You will receive your unique download link of the product via email.',
    'biolink_product_modal.payment_processor' => 'Pay via',
    'biolink_product_modal.submit' => 'Pay',


    'create_biolink_service_modal.header' => 'Add Service',
    'create_biolink_service_modal.subheader' => 'Add a Service button to your profile.',
    'create_biolink_service_modal.service_header' => 'Payment service settings',
    'create_biolink_service_modal.title' => 'Service title',
    'create_biolink_service_modal.description' => 'Service description',
    'create_biolink_service_modal.price' => 'Price',
    'create_biolink_service_modal.currency' => 'Currency code',
    'create_biolink_service_modal.currency_help' => 'Currency code, such as USD, EUR, AUD...etc. Make sure that it is compatible with the payment processor you choose to use.',
    'create_biolink_service_modal.thank_you_title' => 'Thank you title',
    'create_biolink_service_modal.thank_you_description' => 'Thank you description',


    'biolink_service_modal.price' => 'Price',
    'biolink_service_modal.email' => 'Email',
    'biolink_service_modal.email_help' => 'You will be contacted after via email.',
    'biolink_service_modal.message' => 'Your request',
    'biolink_service_modal.payment_processor' => 'Pay via',
    'biolink_service_modal.submit' => 'Pay',


    'create_biolink_block_modal.data_header' => 'Data collection',
    'create_biolink_block_modal.data_help' => 'All collected data is also captured by our system, for you.',
    'create_biolink_block_modal.email_notification' => 'Email',
    'create_biolink_block_modal.email_notification_help' => 'Get notified via email. Leave empty to disable.',
    'create_biolink_block_modal.webhook_url' => 'Webhook URL',
    'create_biolink_block_modal.webhook_url_help' => 'Get notified via webhook. Leave empty to disable.',


    'biolink_link_create_modal.header' => 'Add a new block',


    'tools.breadcrumb' => 'Tools',
    'tools.title' => 'Tools',
    'tools.tool_title' => '%s - Tools',
    'tools.menu' => 'Tools',
    'tools.header' => 'Tools',
    'tools.subheader' => 'Extra useful tools.',

    'tools.dns_lookup.name' => 'DNS Lookup',
    'tools.dns_lookup.description' => 'Find A, AAAA, CNAME, MX, NS, TXT, SOA DNS records of a host.',
    'tools.dns_lookup.host' => 'Host',
    'tools.dns_lookup.error_message' => 'We could not retrieve any DNS records for your given host.',
    'tools.dns_lookup.result.type' => 'Type',
    'tools.dns_lookup.result.host' => 'Host',
    'tools.dns_lookup.result.ttl' => 'TTL',
    'tools.dns_lookup.result.ip' => 'IP',
    'tools.dns_lookup.result.target' => 'Target',
    'tools.dns_lookup.result.ipv6' => 'IPv6',
    'tools.dns_lookup.result.priority' => 'Priority',
    'tools.dns_lookup.result.entries' => 'Entries',
    'tools.dns_lookup.result.mname' => 'MNAME',
    'tools.dns_lookup.result.rname' => 'RNAME',
    'tools.dns_lookup.result.serial' => 'Serial',
    'tools.dns_lookup.result.refresh' => 'Refresh',
    'tools.dns_lookup.result.retry' => 'Retry',
    'tools.dns_lookup.result.expire' => 'Expire',
    'tools.dns_lookup.result.minimum_ttl' => 'Min. TTL',
    'tools.dns_lookup.result.flags' => 'Flags',
    'tools.dns_lookup.result.tag' => 'Tag',
    'tools.dns_lookup.result.value' => 'Value',
    'tools.dns_lookup.result.a' => 'A Records',
    'tools.dns_lookup.result.aaaa' => 'AAAA Records',
    'tools.dns_lookup.result.cname' => 'CNAME Records',
    'tools.dns_lookup.result.mx' => 'MX Records',
    'tools.dns_lookup.result.ns' => 'NS Records',
    'tools.dns_lookup.result.txt' => 'TXT Records',
    'tools.dns_lookup.result.soa' => 'SOA Records',
    'tools.dns_lookup.result.caa' => 'CAA Records',
    'tools.dns_lookup.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.ip_lookup.name' => 'IP Lookup',
    'tools.ip_lookup.description' => 'Get approximate IP details.',
    'tools.ip_lookup.ip' => 'IP',
    'tools.ip_lookup.error_message' => 'We could not retrieve any details for your given IP.',
    'tools.ip_lookup.result.continent' => 'Continent',
    'tools.ip_lookup.result.country' => 'Country',
    'tools.ip_lookup.result.city' => 'City',
    'tools.ip_lookup.result.latitude' => 'Latitude',
    'tools.ip_lookup.result.longitude' => 'Longitude',
    'tools.ip_lookup.result.timezone' => 'Timezone',
    'tools.ip_lookup.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.ssl_lookup.name' => 'SSL Lookup',
    'tools.ssl_lookup.description' => 'Get all possible details about an SSL certificate.',
    'tools.ssl_lookup.host' => 'Host',
    'tools.ssl_lookup.error_message' => 'We could not retrieve any details for your given host.',
    'tools.ssl_lookup.result.country' => 'Country',
    'tools.ssl_lookup.result.organization' => 'Organization',
    'tools.ssl_lookup.result.common_name' => 'Common name',
    'tools.ssl_lookup.result.start_datetime' => 'Issued on',
    'tools.ssl_lookup.result.end_datetime' => 'Expiring on',
    'tools.ssl_lookup.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.whois_lookup.name' => 'Whois Lookup',
    'tools.whois_lookup.description' => 'Get all possible details about a domain name.',
    'tools.whois_lookup.domain_name' => 'Domain name',
    'tools.whois_lookup.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.whois_lookup.result.nameservers' => 'Nameservers',
    'tools.whois_lookup.result.registrar' => 'Registrar',
    'tools.whois_lookup.result.start_datetime' => 'Issued on',
    'tools.whois_lookup.result.end_datetime' => 'Expiring on',
    'tools.whois_lookup.result.updated_datetime' => 'Updated on',
    'tools.whois_lookup.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.ping.name' => 'Ping',
    'tools.ping.description' => 'Ping a website, server or port..',
    'tools.ping.type' => 'Ping Protocol',
    'tools.ping.type_website' => 'HTTP(s)',
    'tools.ping.type_website_help' => 'Ideal for monitoring websites, APIs and web services.',
    'tools.ping.type_ping' => 'Ping (ICMP)',
    'tools.ping.type_ping_help' => 'Ideal for monitoring a server.',
    'tools.ping.type_port' => 'Host / Port',
    'tools.ping.type_port_help' => 'Ideal for monitoring databases, POP or SMTP servers.',
    'tools.ping.target_url' => 'URL',
    'tools.ping.target_host' => 'Host',
    'tools.ping.target_port' => 'Port',
    'tools.ping.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.ping.result.ping_server_id' => 'Ping Server',
    'tools.ping.result.status' => 'Status',
    'tools.ping.result.is_ok' => 'Up!',
    'tools.ping.result.is_not_ok' => 'Down!',
    'tools.ping.result.response_time' => 'Response time',
    'tools.ping.result.response_status_code' => 'Response status code',
    'tools.ping.result.error' => 'Error',
    'tools.ping.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.md5_generator.name' => 'MD5 generator',
    'tools.md5_generator.description' => 'Generate an MD5 hash of 32 characters length for any string input.',
    'tools.md5_generator.text' => 'Text',
    'tools.md5_generator.result' => 'MD5 Hash',
    'tools.md5_generator.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.base64_converter.name' => 'Base64 converter',
    'tools.base64_converter.description' => 'Use Base64 to encode or decode any string input.',
    'tools.base64_converter.text' => 'Text',
    'tools.base64_converter.type' => 'Type',
    'tools.base64_converter.encode' => 'Encode',
    'tools.base64_converter.decode' => 'Decode',
    'tools.base64_converter.result.encoded' => 'Base64 encoded',
    'tools.base64_converter.result.decoded' => 'Base64 decoded',
    'tools.base64_converter.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.base64_image_converter.name' => 'Base64 image converter',
    'tools.base64_image_converter.description' => 'Encode or decode an image using Base64.',
    'tools.base64_image_converter.text' => 'Text',
    'tools.base64_image_converter.image' => 'Image',
    'tools.base64_image_converter.type' => 'Type',
    'tools.base64_image_converter.image_to_base64' => 'Image to Base64',
    'tools.base64_image_converter.base64_to_image' => 'Base64 to Image',
    'tools.base64_image_converter.download' => 'Download',
    'tools.base64_image_converter.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.url_converter.name' => 'URL converter',
    'tools.url_converter.description' => 'Encode or decode any string input to the URL format.',
    'tools.url_converter.text' => 'Text',
    'tools.url_converter.type' => 'Type',
    'tools.url_converter.encode' => 'Encode',
    'tools.url_converter.decode' => 'Decode',
    'tools.url_converter.result.encoded' => 'URL encoded',
    'tools.url_converter.result.decoded' => 'URL decoded',
    'tools.url_converter.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.lorem_ipsum_generator.name' => 'Lorem Ipsum generator',
    'tools.lorem_ipsum_generator.description' => 'Easily generate dummy text with the Lorem Ipsum generator.',
    'tools.lorem_ipsum_generator.amount' => 'Amount',
    'tools.lorem_ipsum_generator.type' => 'Type',
    'tools.lorem_ipsum_generator.paragraphs' => 'Paragraphs',
    'tools.lorem_ipsum_generator.sentences' => 'Sentences',
    'tools.lorem_ipsum_generator.words' => 'Words',
    'tools.lorem_ipsum_generator.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.markdown_to_html.name' => 'Markdown to HTML',
    'tools.markdown_to_html.description' => 'Convert markdown snippets to raw HTML code.',
    'tools.markdown_to_html.markdown' => 'Markdown',
    'tools.markdown_to_html.html' => 'HTML',
    'tools.markdown_to_html.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.case_converter.name' => 'Case converter',
    'tools.case_converter.description' => 'Convert your text to any kind of text case, such as lowercase, UPPERCASE, camelCase...etc.',
    'tools.case_converter.text' => 'Text',
    'tools.case_converter.type' => 'Type',
    'tools.case_converter.lowercase' => 'lowercase',
    'tools.case_converter.uppercase' => 'UPPERCASE',
    'tools.case_converter.sentencecase' => 'Sentence case',
    'tools.case_converter.camelcase' => 'camelCase',
    'tools.case_converter.pascalcase' => 'PascalCase',
    'tools.case_converter.capitalcase' => 'Capital Case',
    'tools.case_converter.constantcase' => 'CONSTANT_CASE',
    'tools.case_converter.dotcase' => 'dot.case',
    'tools.case_converter.snakecase' => 'snake_case',
    'tools.case_converter.paramcase' => 'param-case',
    'tools.case_converter.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.uuid_v4_generator.name' => 'UUID v4 generator',
    'tools.uuid_v4_generator.description' => 'Easily generate v4 UUID\'s (Universally unique identifier) with the help of our tool.',
    'tools.uuid_v4_generator.result' => 'UUID v4',
    'tools.uuid_v4_generator.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.bcrypt_generator.name' => 'Bcrypt generator',
    'tools.bcrypt_generator.description' => 'Generate a bcrypt password hash for any string input.',
    'tools.bcrypt_generator.text' => 'Text',
    'tools.bcrypt_generator.result' => 'Bcrypt Hash',
    'tools.bcrypt_generator.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.password_generator.name' => 'Password generator',
    'tools.password_generator.description' => 'Generate passwords with custom length and custom settings.',
    'tools.password_generator.characters' => 'Characters',
    'tools.password_generator.numbers' => 'Include numbers',
    'tools.password_generator.symbols' => 'Include symbols',
    'tools.password_generator.lowercase' => 'Include lowercase characters',
    'tools.password_generator.uppercase' => 'Include UPPERCASE characters',
    'tools.password_generator.result' => 'Password',
    'tools.password_generator.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.password_strength_checker.name' => 'Password strength checker',
    'tools.password_strength_checker.description' => 'Make sure your passwords are good enough.',
    'tools.password_strength_checker.password' => 'Password',
    'tools.password_strength_checker.characters' => 'Characters',
    'tools.password_strength_checker.strength' => 'Strength',
    'tools.password_strength_checker.strength.no_data' => 'No data',
    'tools.password_strength_checker.strength.very_low' => 'Very low',
    'tools.password_strength_checker.strength.low' => 'Low',
    'tools.password_strength_checker.strength.moderate' => 'Moderate',
    'tools.password_strength_checker.strength.strong' => 'Strong',
    'tools.password_strength_checker.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.slug_generator.name' => 'Slug generator',
    'tools.slug_generator.description' => 'Generate a URL slug for any string input.',
    'tools.slug_generator.text' => 'Text',
    'tools.slug_generator.result' => 'Slug',
    'tools.slug_generator.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.html_minifier.name' => 'HTML minifier',
    'tools.html_minifier.description' => 'Minify your HTML by removing all the unnecessary characters.',
    'tools.html_minifier.html' => 'HTML',
    'tools.html_minifier.result' => 'Minified HTML',
    'tools.html_minifier.result.html_characters' => 'HTML characters',
    'tools.html_minifier.result.minified_html_characters' => 'Minified HTML characters',
    'tools.html_minifier.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.css_minifier.name' => 'CSS minifier',
    'tools.css_minifier.description' => 'Minify your CSS by removing all the unnecessary characters.',
    'tools.css_minifier.css' => 'CSS',
    'tools.css_minifier.result' => 'Minified CSS',
    'tools.css_minifier.result.css_characters' => 'CSS characters',
    'tools.css_minifier.result.minified_css_characters' => 'Minified CSS characters',
    'tools.css_minifier.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.js_minifier.name' => 'JS minifier',
    'tools.js_minifier.description' => 'Minify your JS by removing all the unnecessary characters.',
    'tools.js_minifier.js' => 'JS',
    'tools.js_minifier.result' => 'Minified JS',
    'tools.js_minifier.result.js_characters' => 'JS characters',
    'tools.js_minifier.result.minified_js_characters' => 'Minified JS characters',
    'tools.js_minifier.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.user_agent_parser.name' => 'User agent parser',
    'tools.user_agent_parser.description' => 'Parse details from user agent strings.',
    'tools.user_agent_parser.user_agent' => 'User agent',
    'tools.user_agent_parser.result.browser' => 'Browser',
    'tools.user_agent_parser.result.os' => 'Operating system',
    'tools.user_agent_parser.result.device_type' => 'Device type',
    'tools.user_agent_parser.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.website_hosting_checker.name' => 'Website hosting checker',
    'tools.website_hosting_checker.description' => 'Get the web-host of a given website.',
    'tools.website_hosting_checker.host' => 'Host',
    'tools.website_hosting_checker.error_message' => 'We could not retrieve any details for your given host.',
    'tools.website_hosting_checker.result.isp' => 'ISP',
    'tools.website_hosting_checker.result.org' => 'Organization',
    'tools.website_hosting_checker.result.country' => 'Country',
    'tools.website_hosting_checker.result.city' => 'City',
    'tools.website_hosting_checker.result.latitude' => 'Latitude',
    'tools.website_hosting_checker.result.longitude' => 'Longitude',
    'tools.website_hosting_checker.result.timezone' => 'Timezone',
    'tools.website_hosting_checker.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.character_counter.name' => 'Character counter',
    'tools.character_counter.description' => 'Count the amount of characters and words of a given text.',
    'tools.character_counter.text' => 'Text',
    'tools.character_counter.result.characters' => 'Characters',
    'tools.character_counter.result.words' => 'Words',
    'tools.character_counter.result.lines' => 'Lines',
    'tools.character_counter.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.url_parser.name' => 'URL parser',
    'tools.url_parser.description' => 'Parse details from any URLs.',
    'tools.url_parser.url' => 'URL',
    'tools.url_parser.result.scheme' => 'Scheme',
    'tools.url_parser.result.host' => 'Host',
    'tools.url_parser.result.path' => 'Path',
    'tools.url_parser.result.query' => 'Query',
    'tools.url_parser.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.color_converter.name' => 'Color converter',
    'tools.color_converter.description' => 'Convert your color to multiple other formats.',
    'tools.color_converter.color' => 'Color',
    'tools.color_converter.color_help' => 'Accepted formats: HEX, HEX alpha, RGB, RGBA, HSV, HSL, HSLA.',
    'tools.color_converter.hex' => 'HEX',
    'tools.color_converter.hexa' => 'HEX Alpha',
    'tools.color_converter.rgb' => 'RGB',
    'tools.color_converter.rgba' => 'RGBA',
    'tools.color_converter.hsv' => 'HSV',
    'tools.color_converter.hsl' => 'HSL',
    'tools.color_converter.hsla' => 'HSLA',
    'tools.color_converter.error_message' => 'No valid color format was detected.',
    'tools.color_converter.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.http_headers_lookup.name' => 'HTTP headers lookup',
    'tools.http_headers_lookup.description' => 'Get all the HTTP headers that an URL returns for a typical GET request.',
    'tools.http_headers_lookup.url' => 'URL',
    'tools.http_headers_lookup.error_message' => 'We could not get any information for your entered URL.',
    'tools.http_headers_lookup.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.duplicate_lines_remover.name' => 'Duplicate lines remover',
    'tools.duplicate_lines_remover.description' => 'Easily remove duplicate lines from a text.',
    'tools.duplicate_lines_remover.text' => 'Text',
    'tools.duplicate_lines_remover.result.lines' => 'Lines',
    'tools.duplicate_lines_remover.result.new_lines' => 'New lines',
    'tools.duplicate_lines_remover.result.removed_lines' => 'Removed lines',
    'tools.duplicate_lines_remover.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.text_to_speech.name' => 'Text to speech',
    'tools.text_to_speech.description' => 'Use the Google translator API to generate text to speech audio.',
    'tools.text_to_speech.text' => 'Text',
    'tools.text_to_speech.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.idn_punnycode_converter.name' => 'IDN Punnycode converter',
    'tools.idn_punnycode_converter.description' => 'Easily convert IDN to Punnycode and back.',
    'tools.idn_punnycode_converter.content' => 'Content',
    'tools.idn_punnycode_converter.type' => 'Type',
    'tools.idn_punnycode_converter.to_punnycode' => 'Convert to Punnycode/ASCII',
    'tools.idn_punnycode_converter.to_idn' => 'Convert to IDN/Text',
    'tools.idn_punnycode_converter.result.punnycode' => 'Punnycode/ASCII',
    'tools.idn_punnycode_converter.result.idn' => 'IDN/Text',
    'tools.idn_punnycode_converter.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.json_validator_beautifier.name' => 'JSON validator & beautifier',
    'tools.json_validator_beautifier.description' => 'Validate JSON content and make it looks good.',
    'tools.json_validator_beautifier.json' => 'JSON',
    'tools.json_validator_beautifier.error_message' => 'JSON content is invalid.',
    'tools.json_validator_beautifier.success_message' => 'JSON content is valid.',
    'tools.json_validator_beautifier.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.qr_code_reader.name' => 'QR code reader',
    'tools.qr_code_reader.description' => 'Upload a QR code image and extract the data out of it.',
    'tools.qr_code_reader.image' => 'QR code image',
    'tools.qr_code_reader.result' => 'Data',
    'tools.qr_code_reader.result.no_data' => 'No data found.',
    'tools.qr_code_reader.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.meta_tags_checker.name' => 'Meta tags checker',
    'tools.meta_tags_checker.description' => 'Get & verify the meta tags of any website.',
    'tools.meta_tags_checker.url' => 'URL',
    'tools.meta_tags_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.meta_tags_checker.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.exif_reader.name' => 'Exif reader',
    'tools.exif_reader.description' => 'Upload a image and extract the data out of it.',
    'tools.exif_reader.image' => 'Image',
    'tools.exif_reader.result' => 'Data',
    'tools.exif_reader.result.no_data' => 'No data found.',
    'tools.exif_reader.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.sql_beautifier.name' => 'SQL formatter/beautifier',
    'tools.sql_beautifier.description' => 'Format & beautify your SQL code with ease.',
    'tools.sql_beautifier.sql' => 'SQL',
    'tools.sql_beautifier.result' => 'Beautified SQL',
    'tools.sql_beautifier.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',

    'tools.html_entity_converter.name' => 'HTML entity converter',
    'tools.html_entity_converter.description' => 'Encode or decode HTML entities for any given input.',
    'tools.html_entity_converter.text' => 'Text',
    'tools.html_entity_converter.type' => 'Type',
    'tools.html_entity_converter.encode' => 'Encode',
    'tools.html_entity_converter.decode' => 'Decode',
    'tools.html_entity_converter.result.encoded' => 'HTML entity encoded',
    'tools.html_entity_converter.result.decoded' => 'HTML entity decoded',
    'tools.html_entity_converter.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',
];
